

<?php $__env->startSection('content'); ?>
<?php
    $settings = DB::table('settings')->where('id', 1)->first();
    $stat = App\Models\StatusControl::get();
?>

<div class="content">
    <div class="card">
        <div class="card-body">
            <!-- Change Order Status -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="form-group">
                        <label class="form-label">Change Order Status <span class="text-danger">*</span></label>
                        <div class="dropdown">
                            <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                <?php echo e($data->status); ?>

                            </button>
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                <?php $__currentLoopData = $stat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statusOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a class="dropdown-item" href="<?php echo e(route('sales.status', [$data->id, $statusOption->name])); ?>"><?php echo e($statusOption->name); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Invoice Header -->
            <div class="row mb-5">
                <div class="col-lg-12 d-flex justify-content-between align-items-center">
                    <div id="logo">
                        <img src="<?php echo e(URL::to('')); ?>/<?php echo e($settings->logo); ?>" alt="Logo" style="width: 150px; border-radius: 5px;">
                    </div>
                    <div class="text-end">
                        <h3 class="mb-2"><?php echo e($settings->website); ?></h3>
                        <p class="mb-1"><?php echo $settings->address; ?></p>
                        <p class="mb-0"><?php echo e($settings->phone); ?></p>
                    </div>
                </div>
                <div class="col-12 text-center mt-4">
                    <h1 class="text-muted font-40 mb-4">INVOICE</h1>
                </div>
            </div>

             <!-- Customer and Invoice Details -->
            <div class="invoice-details">
                <div class="row">
                    <div class="col-sm-6">
                        <h5>Billed To:</h5>
                        <p><?php echo e($data->first_name); ?></p>
                        <p><?php echo e($data->address); ?></p>
                        <p><?php echo e($data->phone); ?></p>
                    </div>
                    <div class="col-sm-6 text-sm-end">
                        <div>
                            <h5>Invoice No:</h5>
                            <p><?php echo e($data->id); ?></p>
                        </div>
                        <div>
                            <h5>Order No:</h5>
                            <p><?php echo e($data->order_number); ?></p>
                        </div>
                        <div>
                            <h5>Invoice Date:</h5>
                            <p><?php echo e($data->created_at->format('d-M-Y h:i A')); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Order Summary -->
            <div class="py-4">
                <h5 class="font-size-15 mb-3">Order Summary</h5>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th style="width: 70px;">No.</th>
                                <th>Item</th>
                                <th>Price</th>
                                <th>Quantity</th>
                                <th class="text-end" style="width: 120px;">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(isset($product)): ?>
                                <?php $__currentLoopData = $product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><?php echo e($loop->index + 1); ?></th>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <img src="<?php echo e(URL::to('')); ?>/<?php echo e($row->product_photo); ?>" alt="product" class="img-fluid me-3" style="max-width: 60px; border-radius: 5px;">
                                                <div>
                                                    <p class="text-muted mb-0"><?php echo e($row->product_title); ?></p>
                                                    <?php if($row->color): ?> <p class="mb-0"><small>Color: <?php echo e($row->color); ?></small></p> <?php endif; ?>
                                                    <?php if($row->size): ?> <p class="mb-0"><small>Size: <?php echo e($row->size); ?></small></p> <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e(number_format($data->sub_total, 2)); ?></td>
                                        <td><?php echo e($row->quantity); ?></td>
                                        <td class="text-end"><?php echo e(number_format($data->total_amount, 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                            <!-- Totals -->
                            <tr>
                                <th scope="row" colspan="4" class="text-end">Sub Total</th>
                                <td class="text-end"><?php echo e(number_format($data->sub_total, 2)); ?></td>
                            </tr>
                            <tr>
                                <th scope="row" colspan="4" class="text-end">Discount:</th>
                                <td class="text-end">-<?php echo e(number_format($data->discount, 2)); ?></td>
                            </tr>
                            <tr>
                                <th scope="row" colspan="4" class="text-end">Shipping Charge:</th>
                                <td class="text-end"><?php echo e(number_format($data->shipping_cost, 2)); ?></td>
                            </tr>
                            <tr>
                                <th scope="row" colspan="4" class="text-end">Total</th>
                                <td class="text-end">
                                    <h4 class="m-0 fw-bold"><?php echo e(number_format($data->total_amount, 2)); ?></h4>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row" colspan="4" class="text-end">PAID</th>
                                <td class="text-end">
                                    <h4 class="m-0 fw-bold"><?php echo e(number_format($data->payment, 2)); ?></h4>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row" colspan="4" class="text-end">Due</th>
                                <td class="text-end">
                                    <h4 class="m-0 fw-bold"><?php echo e(number_format($data->total_amount - $data->payment, 2)); ?></h4>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<style>
    .invoice-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 30px;
    }

    .invoice-header img {
        width: 150px;
        border-radius: 5px;
    }

    .invoice-header .company-info {
        text-align: right;
    }

    .invoice-title {
        text-align: center;
        margin: 20px 0;
    }

    .invoice-title h1 {
        font-size: 3rem;
        color: #333;
    }

    .invoice-details, .order-summary {
        margin-bottom: 30px;
    }

    .invoice-details h5 {
        font-size: 1.25rem;
        margin-bottom: 10px;
    }

    .invoice-details p {
        margin: 5px 0;
    }

    .order-summary {
        font-size: 1rem;
    }

    .order-summary .table {
        border: 1px solid #ddd;
        border-radius: 5px;
        overflow: hidden;
    }

    .order-summary .table thead {
        background-color: #f9f9f9;
        font-weight: bold;
    }

    .order-summary .table tbody tr:nth-child(even) {
        background-color: #f2f2f2;
    }

    .order-summary .table td, .order-summary .table th {
        padding: 12px;
        text-align: center;
    }

    .order-summary .table .product-img {
        display: flex;
        align-items: center;
    }

    .order-summary .table .product-img img {
        max-width: 60px;
        border-radius: 5px;
        margin-right: 10px;
    }

    .order-summary .table .text-end {
        text-align: right;
    }

    .order-summary .table h4 {
        margin: 0;
        font-weight: bold;
    }

    .order-summary .table .font-size-15 {
        font-size: 1rem;
    }
</style>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rajragsc/public_html/resources/views/backend/sales/show.blade.php ENDPATH**/ ?>