<?php
$settings=DB::table('settings')->where('id',1)->first();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Invoice</title>
    <style>
    .clearfix:after {
        content: "";
        display: table;
        clear: both;
    }

    a {
        color: #5D6975;
        text-decoration: underline;
    }

    body {
        position: relative;
        width: 18cm;
        height: auto;
        margin: 0 auto;
        color: #001028;
        background: #FFFFFF;
        font-family: Arial, sans-serif;
        font-size: 12px;
        font-family: Arial;
    }

    header {
        padding: 10px 0;
        margin-bottom: 30px;
    }

    #logo {
        text-align: center;
        margin-bottom: 10px;
    }

    #logo img {
        width: 90px;
    }

    h1 {
        border-top: 1px solid #5D6975;
        border-bottom: 1px solid #5D6975;
        color: #5D6975;
        font-size: 2.4em;
        line-height: 1.4em;
        font-weight: normal;
        text-align: center;
        margin: 0 0 20px 0;
        background: url(dimension.png);
    }

    #project {
        float: left;
    }
    address {
        font-style: normal;
    }
    #project span {
        color: #5D6975;
        text-align: right;
        width: 52px;
        margin-right: 10px;
        display: inline-block;
        font-size: 0.8em;
    }

    #company {
        float: right;
        text-align: right;
    }

    #project div,
    #company div {
        white-space: nowrap;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        border-spacing: 0;
        margin-bottom: 20px;
    }

    table tr:nth-child(2n-1) td {
        background: #F5F5F5;
    }
    .thick-line {
        padding: 12px;
    }
    table th,
    table td {
        text-align: center;
    }

    table th {
        padding: 5px 20px;
        color: #5D6975;
        border-bottom: 1px solid #C1CED9;
        white-space: nowrap;
        font-weight: normal;
    }

    table .service,
    table .desc {
        text-align: left;
    }

    table td {
        padding: 20px;
        text-align: right;
    }

    table td.service,
    table td.desc {
        vertical-align: top;
    }

    table td.unit,
    table td.qty,
    table td.total {
        font-size: 1.2em;
    }

    table td.grand {
        border-top: 1px solid #5D6975;
        ;
    }

    #notices .notice {
        color: #5D6975;
        font-size: 1.2em;
    }

    footer {
        color: #5D6975;
        width: 100%;
        height: 30px;
        position: absolute;
        bottom: 0;
        border-top: 1px solid #C1CED9;
        padding: 8px 0;
        text-align: center;
    }
    </style>
</head>

<body>
    <header class="clearfix">
        <div id="logo">
            <img src="<?php echo e(URL::to('')); ?>/<?php echo e($settings->logo); ?>" style="width:150px;">
        </div>
        <h1>INVOICE #<?php echo e($settings->order_prefix); ?><?php echo e($data->id); ?></h1>
        <div id="company" class="clearfix">
            <address>
                <strong>Billed By:</strong><br>
                <?php echo e($settings->website); ?><br>
                Address: <?php echo $settings->address; ?><br>
                Phone: <?php echo e($settings->phone); ?>

            </address>
        </div>
        <div id="project">
            <address>
                <strong>Billed To:</strong><br>
                Name: <?php echo e($data->first_name); ?><br>
                Address: <?php echo e($data->address); ?> <br>
                Phone: <?php echo e($data->phone); ?>

            </address>
        </div>

    </header>
    <header>
        <div id="project">
            <address>
                <strong>Order Date:</strong><br>
                <?php echo e($data->created_at->format('d-M-Y h:i A')); ?><br><br>
            </address>
        </div>
    </header>
    <main>
        <table>
            <thead>
                <tr>
                    <td class="service"><strong>Item</strong></td>
                    <td class="text-center"><strong>Quantity</strong></td>
                    <td class="text-center"><strong>Price</strong></td>
                    <td class="text-right"><strong>Total</strong></td>
                </tr>
            </thead>
            <tbody>
                <?php if(isset($product)): ?>
                <?php $__currentLoopData = $product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="service"><?php echo e($loop->index+1); ?>. <?php echo e($row->product_title); ?></td>
                    <td class="text-center"><?php echo e($row->quantity); ?></td>
                    <td class="text-center">Tk <?php echo e($row->price); ?></td>
                    <td class="text-right">Tk <?php echo e($row->amount); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <tr>
                    <td class="thick-line"></td>
                    <td class="thick-line"></td>
                    <td class="thick-line text-center">Subtotal</td>
                    <td class="thick-line text-right">Tk <?php echo e($data->sub_total); ?></td>
                </tr>
                <tr>
                    <td class="thick-line no-line"></td>
                    <td class="thick-line no-line"></td>
                    <td class="thick-line no-line text-center">Shipping</td>
                    <td class="thick-line no-line text-right">Tk <?php echo e($data->shipping_cost); ?></td>
                </tr>
                <tr>
                    <td class="thick-line no-line"></td>
                    <td class="thick-line no-line"></td>
                    <td class="thick-line no-line text-center">Discount</td>
                    <td class="thick-line no-line text-right">Tk <?php echo e($data->discount); ?></td>
                </tr>
                <tr>
                    <td colspan="3" class="grand total"><strong>TOTAL</strong></td>
                    <td class="grand total">Tk <?php echo e($data->total_amount); ?></td>
                </tr>
                <tr>
                    <td colspan="3" class="grand total"><strong>PAID</strong></td>
                    <td class="grand total">Tk <?php echo e($data->payment); ?></td>
                </tr>
                <tr>
                    <td colspan="3" class="grand total"><strong>DUE</strong></td>
                    <td class="grand total">Tk <?php echo e($data->total_amount -$data->payment); ?></td>
                </tr>
            </tbody>
        </table>
    </main>
</body>

</html><?php /**PATH /home/honicma1/demo1.everrivo.com/resources/views/backend/report/invoice.blade.php ENDPATH**/ ?>