<?php
$settings=DB::table('settings')->where('id',1)->first();
?>
<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <title>Invoice</title>
      <style>
         .clearfix:after {
         content: "";
         display: table;
         clear: both;
         }
         a {
         color: #5D6975;
         text-decoration: underline;
         }
         body {
         position: relative;
         width: 18cm;
         height: auto;
         margin: 0 auto;
         color: #001028;
         background: #FFFFFF;
         font-family: Arial, sans-serif;
         font-size: 12px;
         font-family: Arial;
         }
         header {
         padding: 10px 0;
         margin-bottom: 30px;
         }
         #logo {
         text-align: center;
         margin-bottom: 10px;
         }
         #logo img {
         width: 90px;
         }
         h2 {
         border-top: 1px solid #000;
         border-bottom: 1px solid #000;
         color: #4a5056;
         font-size: 20px;
         line-height: 1.4em;
         font-weight: 500;
         text-align: center;
         margin: 0 0 20px 0;
         }
         #project {
         float: left;
         }
         address {
         font-style: normal;
         }
         #project span {
         color: #5D6975;
         text-align: right;
         width: 52px;
         margin-right: 10px;
         display: inline-block;
         font-size: 0.8em;
         }
         #company {
         float: right;
         text-align: right;
         }
         #project div,
         #company div {
         white-space: nowrap;
         }
         table {
         width: 100%;
         border-collapse: collapse;
         margin-bottom: 20px;
         }
         table th, table td {
         border: 1px solid #ddd;
         padding: 8px;
         text-align: left;
         }
         table th {
         background-color: #f2f2f2;
         color: #333;
         }
         table td {
         background-color: #fff;
         }
         .text-right {
         text-align: right;
         }
         .text-center {
         text-align: center;
         }
         .thick-line {
         border-top: 2px solid #5D6975;
         }
         .no-line {
         border: none;
         }
         .grand {
         font-weight: bold;
         }
         .productimgname img{
         margin-right: 10px;
         }
         .product-img{
         min-width: 40px;
         width: 40px;
         height: 40px;
         border: 0;
         }
         img {
         max-width: 100%;
         height: auto;
         }
         #notices .notice {
         color: #5D6975;
         font-size: 1.2em;
         }
         footer {
         color: #5D6975;
         width: 100%;
         height: 30px;
         position: absolute;
         bottom: 0;
         border-top: 1px solid #C1CED9;
         padding: 8px 0;
         text-align: center;
         }
      </style>
   </head>
   <body>
      <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <header class="clearfix">
         <div id="logo">
            <img src="<?php echo e(URL::to('')); ?>/<?php echo e($settings->logo); ?>" style="width:150px;">
         </div>
         <h2>INVOICE #<?php echo e($invoice['order']->order_number); ?></h2>
         <div id="company" class="clearfix">
            <address>
               <strong>Billed By:</strong><br>
               <?php echo e($settings->website); ?><br>
               Address: <?php echo $settings->address; ?><br>
               Phone: <?php echo e($settings->phone); ?>

            </address>
         </div>
         <div id="project">
            <address>
               <strong>Billed To:</strong><br>
               Name: <?php echo e($invoice['order']->first_name); ?><br>
               Address: <?php echo e($invoice['order']->address); ?> <br>
               Phone: <?php echo e($invoice['order']->phone); ?>

            </address>
         </div>
      </header>
      <header>
         <div id="company" class="clearfix">
            <address>
               <strong>Order id:</strong><br>
               <?php echo e($invoice['order']->id); ?>

            </address>
         </div>
         <div id="project">
            <address>
               <strong>Order Date:</strong><br>
               <?php echo e($invoice['order']->created_at->format('d-M-Y h:i A')); ?>

            </address>
         </div>
      </header>
      <main>
         <table>
            <thead>
               <tr>
                  <td class="service"><strong>Item</strong></td>
                  <td class="text-center"><strong>Quantity</strong></td>
                  <td class="text-center"><strong>Price</strong></td>
                  <td class="text-right"><strong>Total</strong></td>
               </tr>
            </thead>
            <tbody>
               <?php $__currentLoopData = $invoice['products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
               <tr>
                  <td class="service">
                     <div style="display: flex; align-items: center;">
                        <?php echo e($loop->iteration); ?>. 
                       <div class="product-img">
    <?php if(!empty($product['product']->product_photo)): ?>
        <img src="<?php echo e(URL::to('/')); ?>/<?php echo e($product['product']->product_photo); ?>" alt="Product Image">
    <?php else: ?>
        <p>No image available</p>
    <?php endif; ?>
</div>
<?php if(!empty($product['product']->product_title)): ?>
                        <span style="margin-left: 10px;"> <?php echo e($product['product']->product_title); ?></span>
                        <?php endif; ?>
                     </div>
                     <br>
                     <?php if($product['product']->color): ?> Color: <?php echo e($product['product']->color); ?> <?php endif; ?> <br>
                     <?php if($product['product']->size): ?> Size: <?php echo e($product['product']->size); ?> <?php endif; ?> <br>
                     <?php if($product['product']->liquid): ?> Liquid: <?php echo e($product['product']->liquid); ?> <?php endif; ?>
                  </td>
                  <td class="text-center"><?php echo e($product['detail']->quantity); ?></td>
                  <td class="text-center">
                     <?php if($product['product']->size): ?>
                     <?php if(!empty($product['product_size_id']->price)): ?>
                     Tk <?php echo e($product['product_size_id']->price); ?>

                     <?php endif; ?>
                     <?php else: ?>
                     Tk <?php echo e($product['detail']->price); ?>

                     <?php endif; ?>
                  </td>
                  <td class="text-right">
                     <?php if($product['product']->size): ?>
                     <?php
                     $total = $product['product_size_id']->price * $product['detail']->quantity;
                     ?>
                     Tk <?php echo e($total); ?>

                     <?php else: ?>
                     Tk <?php echo e($product['detail']->price); ?>

                     <?php endif; ?>
                  </td>
               </tr>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
               <tr>
                  <td colspan="3" class="grand text-right">Subtotal</td>
                  <td class="grand text-right">Tk <?php echo e($invoice['order']->sub_total); ?></td>
               </tr>
               <tr>
                  <td colspan="3" class="grand text-right">Shipping</td>
                  <td class="grand text-right">Tk <?php echo e($invoice['order']->shipping_cost); ?></td>
               </tr>
               <tr>
                  <td colspan="3" class="grand text-right">Discount</td>
                  <td class="grand text-right">Tk <?php echo e($invoice['order']->discount); ?></td>
               </tr>
               <tr>
                  <td colspan="3" class="grand text-right">TOTAL</td>
                  <td class="grand text-right">Tk <?php echo e($invoice['order']->total_amount); ?></td>
               </tr>
               <tr>
                  <td colspan="3" class="grand text-right">PAID</td>
                  <td class="grand text-right">Tk <?php echo e($invoice['order']->payment); ?></td>
               </tr>
               <tr>
                  <td colspan="3" class="grand text-right">DUE</td>
                  <td class="grand text-right">Tk <?php echo e($invoice['order']->total_amount - $invoice['order']->payment); ?></td>
               </tr>
            </tbody>
         </table>
      </main>
      <footer>
         Invoice was created on a computer and is valid without the signature and seal.
      </footer>
      <div style="page-break-after: always;"></div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
   </body>
</html><?php /**PATH /home/rajragsc/public_html/resources/views/backend/report/bulkindex.blade.php ENDPATH**/ ?>