<!DOCTYPE html>
<html>
<head>
    <title>Sales Report</title>
</head>
<?php
$settings=DB::table('settings')->where('id',1)->first();
?>
<?php 
    $stat = App\Models\StatusControl::get();
    $totalorder = App\Models\Order::count();
    $Placed_order = App\Models\Order::where('status','New Order')->count();
    $Cancel_order = App\Models\Order::where('status','Cancel')->count();
    $DeliveryDone = App\Models\Order::where('status','Delivery Done')->count();
?>
<style type="text/css">
    body{
        font-family: 'Roboto Condensed', sans-serif;
    }
    .m-0{
        margin: 0px;
    }
    .p-0{
        padding: 0px;
    }
    .pt-5{
        padding-top:5px;
    }
    .mt-10{
        margin-top:10px;
    }
    .text-center{
        text-align:center !important;
    }
    .w-100{
        width: 100%;
    }
    .w-50{
        width:50%;   
    }
    .w-85{
        width:85%;   
    }
    .w-15{
        width:15%;   
    }
    .logo img{
        width:45px;
        height:45px;
        padding-top:30px;
    }
    .logo span{
        margin-left:8px;
        top:19px;
        position: absolute;
        font-weight: bold;
        font-size:25px;
    }
    .gray-color{
        color:#5D5D5D;
    }
    .text-bold{
        font-weight: bold;
    }
    .border{
        border:1px solid black;
    }
    table tr,th,td{
        border: 1px solid #d2d2d2;
        border-collapse:collapse;
        padding:7px 8px;
    }
    table tr th{
        background: #F4F4F4;
        font-size:12px;
    }
    table tr td{
        font-size:10px;
    }
    table{
        border-collapse:collapse;
    }
    .box-text p{
        line-height:10px;
    }
    .float-left{
        float:left;
    }
    .total-part{
        font-size:16px;
        line-height:12px;
    }
    .total-right p{
        padding-right:20px;
    }
</style>
<body>
<div class="head-title">
    <h1 class="text-center m-0 p-0">Order report </h1>
    <p class="text-center"><?php echo e($date); ?></p>
</div>

<div class="table-section bill-tbl w-100 mt-10">
        <table class="table w-100 mt-10">
            <thead>
                <tr>
                    <th>Order ID</th>
                    <th>Order Details</th>
                    <th>Product</th>
                    <th>Account</th>
                    <th>Date</th>
                    <th>Status</th>
                    <th>Note</th>
                </tr>
            </thead>
            <tbody>
            <?php if(count($products)>0): ?>
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   
                <?php 
                    $orderdetails=DB::table('order_details')->where('order_id',$product->id)->get();
                    $productdetails=DB::table('products')->where('id',$product->id)->get();
                ?>
                <tr>
                    <td>
                        <?php echo e($settings->order_prefix); ?><?php echo e($product->id); ?>

                    </td>
                    <td >
                        <?php echo e($product->first_name); ?>, <br> <?php echo e($product->phone); ?>, <br> <?php echo e($product->address); ?>

                    </td>
                    <td>
                    
                    <?php $__currentLoopData = $orderdetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php 
                        $productdetails=DB::table('products')->where('id',$row->product_id)->first();
                    ?>
                    <strong><?php echo e($productdetails->title); ?></strong> <br>
                    <small>SKU: <?php echo e($productdetails->SKU); ?></small> <br>
                    <small><?php if(isset($row->color)): ?> Color: <?php echo e($row->color); ?> <?php endif; ?> <?php if(isset($row->size)): ?> Size: <?php echo e($row->size); ?> <?php endif; ?> </small><br>
                    <small>Quantity: <?php echo e($row->quantity); ?></small> <br>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                    <td>
                        Sub Total: <?php echo e($product->sub_total); ?> <br>
                        Shipping Cost: <?php echo e($product->shipping_cost); ?> <br>
                        Discount: <?php echo e($product->discount); ?> <br>
                        Payment: <?php echo e($product->payment); ?> <br>
                        Total Collectables: <?php echo e($product->total_amount-$product->payment); ?> <br>
                        Total Amount: <?php echo e($product->total_amount); ?> <br>

                    </td>
                    <td><?php echo e($product->created_at->format('Y-m-d h:i A')); ?></td>
                    <td>
                        <span style="text-transform: capitalize;"><?php echo e($product->status); ?></span>
                    </td>
                    <td><?php echo e($product->note); ?></td>

                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <h6 class="text-center">No sale found!!!</h6>
                <?php endif; ?>
            </tbody>
        </table>
</div>
</html><?php /**PATH /home/honicma1/demo1.everrivo.com/resources/views/backend/sales/report.blade.php ENDPATH**/ ?>