

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">POS - Point of Sale</div>

                <div class="card-body">
                    <div class="row mb-4">
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4 mb-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title"><?php echo e($product->title); ?></h5>
                                        <p class="card-text">Price: $<?php echo e($product->offer_price); ?></p>
                                        <p class="card-text">Stock: <?php echo e($product->stock); ?></p>
                                        <p class="card-text">Color: <?php echo e($product->color); ?></p>
                                        <p class="card-text">Sizes: 
                                            <?php $__currentLoopData = $product->sizeVariations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($variation->size->name); ?> ($<?php echo e($variation->price); ?>)
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </p>
                                        <a href="javascript:void(0);" class="btn btn-primary add-to-order"
                                            data-id="<?php echo e($product->id); ?>"
                                            data-title="<?php echo e($product->title); ?>"
                                            data-price="<?php echo e($product->offer_price); ?>"
                                            data-stock="<?php echo e($product->stock); ?>"
                                            data-color="<?php echo e($product->color); ?>"
                                            data-sizes="<?php echo e(json_encode($product->sizeVariations)); ?>">Add to Order</a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div id="order-items" class="card">
                                <div class="card-header">Order Items</div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Product</th>
                                                <th>Price</th>
                                                <th>Quantity</th>
                                                <th>Total</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="order-items-body">
                                            <!-- Order items will be dynamically added here -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12 text-right">
                            <h4>Total: $<span id="order-total">0.00</span></h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('.add-to-order').click(function() {
            const productId = $(this).data('id');
            const productTitle = $(this).data('title');
            const productPrice = parseFloat($(this).data('price'));

            const existingRow = $(`#order-items-body tr[data-product-id=${productId}]`);

            if (existingRow.length > 0) {
                const quantityInput = existingRow.find('.quantity-input');
                const quantity = parseInt(quantityInput.val()) + 1;
                quantityInput.val(quantity);

                const total = quantity * productPrice;
                existingRow.find('.item-total').text(`$${total.toFixed(2)}`);
            } else {
                const newRow = `
                    <tr data-product-id="${productId}">
                        <td>${productTitle}</td>
                        <td>$${productPrice.toFixed(2)}</td>
                        <td><input type="number" class="form-control quantity-input" value="1" min="1"></td>
                        <td class="item-total">$${productPrice.toFixed(2)}</td>
                        <td><button class="btn btn-danger btn-sm remove-item">Remove</button></td>
                    </tr>
                `;
                $('#order-items-body').append(newRow);
            }

            updateOrderTotal();
        });

        $(document).on('click', '.remove-item', function() {
            $(this).closest('tr').remove();
            updateOrderTotal();
        });

        $(document).on('input', '.quantity-input', function() {
            const quantity = parseInt($(this).val());
            const price = parseFloat($(this).closest('tr').find('td:eq(1)').text().replace('$', ''));
            const total = quantity * price;
            $(this).closest('tr').find('.item-total').text(`$${total.toFixed(2)}`);

            updateOrderTotal();
        });

        function updateOrderTotal() {
            let total = 0;
            $('#order-items-body tr').each(function() {
                total += parseFloat($(this).find('.item-total').text().replace('$', ''));
            });

            $('#order-total').text(total.toFixed(2));
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\nova\resources\views/pos.blade.php ENDPATH**/ ?>