<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-GLhlTQ8iRABdZLl6O3oVMWSktQOp6b7In1Zl3/Jr59b6EGGoI1aFkw7cmDA6j6gD" crossorigin="anonymous">
    <style>
    .repos{
        border: 1px solid #d5d1d1;
    padding: 15px;
    margin-bottom: -1px;
    margin-right: -1px;
    }
</style>
<style>
table {
  border-collapse: collapse;
  width: 100%;
}

td, th {
  border: 1px solid #dddddd;
  text-align: left;
  padding: 8px;
}

</style>
</head>
<body>
<div class="content">
    <div class="card" id="printarea">
        <div class="card-body">
            <div class="text-center" style="border-bottom:1px solid black;">
                <h2><?php echo e($settings->website); ?></h2>
                <div>Address: <?php echo e($settings->website); ?></div>
                <div>Phone: <?php echo e($settings->phone); ?></div>
                <div>Email: <?php echo e($settings->email); ?></div><br>
            </div>
            <div class="text-center">
                <br>
                <h2>Full Sales Report</h2>
                <p>Report Date : <?php echo e($fromDate); ?> to <?php echo e($todate); ?></p>
                <br><br>
            </div>
            <div class="table-responsive">
                <table class="table">  
                    <tr>
                        <th colspan="2" class="text-center">Order</th>
                    </tr>
                    <tr>
                        <td>Total Order</td>
                        <td ><?php echo e($total_order); ?></td>
                    </tr>
                    <tr>
                        <td>Total Order Pending</td>
                        <td><?php echo e($total_pending); ?></td>
                    </tr>
                    <tr>
                        <td>Total Order Delivery Done</td>
                        <td><?php echo e($total_deliver); ?></td>
                    </tr>
                    <tr>
                        <td>Total Order Cancel</td>
                        <td><?php echo e($total_cancel); ?></td>
                    </tr>
                    <tr>
                        <th colspan="2" class="text-center">Product</th>
                    </tr>
                    <tr>
                        <td>Total Product in Sale</td>
                        <td><?php echo e($productinsale); ?></td>
                    </tr>
                    <tr>
                        <td>Total Product Pending</td>
                        <td><?php echo e($productsale); ?></td>
                    </tr>
                    <tr>
                        <td>Total Product Delivery</td>
                        <td><?php echo e($productdelivery); ?></td>
                    </tr>
                    <tr>
                        <td>Total Product Cancel</td>
                        <td><?php echo e($productCancel); ?></td>
                    </tr>
                    <tr>
                        <th colspan="2" class="text-center">Sales Delivered</th>
                    </tr>
                    <tr>
                        <td>Total Product Cost Price</td>
                        <td><?php echo e($costprice); ?></td>
                    </tr>
                    <tr>
                        <td>Total Product Price</td>
                        <td><?php echo e($totalprice); ?></td>
                    </tr>
                    <tr>
                        <td>Total Profit</td>
                        <td><?php echo e($grossprofit); ?></td>
                    </tr>
                    <tr>
                        <td>Total Discount</td>
                        <td><?php echo e($totaldiscount); ?></td>
                    </tr>
                    <tr>
                        <td>Total Cancel Cost</td>
                        <td><?php echo e($totalloss); ?></td>
                    </tr>
                    <tr>
                        <td>Total Sale</td>
                        <td><?php echo e($grosssale); ?></td>
                    </tr>
                    <tr>
                        <td>Total Expanse</td>
                        <td><?php echo e($totalexpanse); ?></td>
                    </tr>
                    <tr>
                        <td>Net Profit</td>
                        <td><?php echo e($netprofit); ?></td>
                    </tr>
                </table>
            </div>
           
        </div>
    </div>
    <div class="card"><br><br>
        <div class="card-body">
            <div class="text-center">
               <div class="text-center">
                    <h2>Full Product Report</h2>
                    <p>Report Date : <?php echo e($fromDate); ?> to <?php echo e($todate); ?></p>
                </div><br><br>
            </div>
            <div class="table-responsive">
                <table class="table ">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Product Name</th>
                            <th>SKU</th>
                            <th>Size</th>
                            <th>Color</th>
                            <th>Quantity</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php if(isset($data)): ?>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   
                        <tr>
                            <td><?php echo e($loop->index+1); ?></td>
                            <td><?php echo e($product['product_name']); ?></td>
                            <td><?php echo e($product['sku']); ?></td>
                            <td><?php echo e($product['size']); ?></td>
                            <td><?php echo e($product['color']); ?></td>
                            <td><?php echo e($product['quantity']); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">No order found!!!</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                    
                </table>
            
            </div>
        </div>
    </div>

</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js" integrity="sha384-w76AqPfDkMBDXo30jS1Sgez6pr3x5MlQ1ZAGC+nuZB+EYdgRZgiwxhTBTkF7CXvN" crossorigin="anonymous"></script>
  </body>
</html><?php /**PATH /home/honicma1/demo1.everrivo.com/resources/views/backend/report/pdf.blade.php ENDPATH**/ ?>