

<?php $__env->startSection('content'); ?>
<?php
$settings=DB::table('settings')->where('id',1)->first();
?>
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Expense</h4>
        </div>
        <div class="page-btn">
            <a href="<?php echo e(route('expenses.create')); ?>" class="btn btn-added"><img src="<?php echo e(URL::to('')); ?>/public/assets/img/icons/plus.svg" alt="img"
                    class="me-1">Create Expense</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <?php echo $__env->make('backend.layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <div class="row card" style="padding:20px;">
        <form action="<?php echo e(route('expenses.search')); ?>" class="row" method="POST">
            <?php echo csrf_field(); ?>
            <div class="col-lg-3 col-sm-6 col-12">
                <div class="form-group ">
                    <div class="input-groupicon">
                        <input type="text" placeholder="DD-MM-YYYY"  value="<?php echo e($fromDate); ?>"name="fromDate" class="datetimepicker">
                        <div class="addonset">
                        <img src="<?php echo e(URL::to('')); ?>/public/assets/img/icons/calendars.svg" alt="img">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6 col-12">
                <div class="form-group ">
                    <div class="input-groupicon">
                        <input type="text" placeholder="DD-MM-YYYY" name="todate" value="<?php echo e($todate); ?>" class="datetimepicker">
                        <div class="addonset">
                        <img src="<?php echo e(URL::to('')); ?>/public/assets/img/icons/calendars.svg" alt="img">
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-sm-6 col-12">
            <button type="submit" class="btn btn-success">
                Search
            </button>
            </div>
        </form>
    </div>
    <br>
    <div class="card">
        <div class="card-body">
            <div class="table-top">
                <div class="search-set">
                    <div class="search-input">
                        <a class="btn btn-searchset"><img src="<?php echo e(URL::to('')); ?>/public/assets/img/icons/search-white.svg" alt="img"></a>
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Amount</th>
                            <th>Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php if(count($data)>0): ?>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   
                        <tr>
                            <td><?php echo e($loop->index+1); ?></td>
                            <td><?php echo e($product->title); ?></td>
                            <td><?php echo e($product->description); ?></td>
                            <td><?php echo e($product->amount); ?></td>
                            <td><?php echo e($product->created_at->format('d-m-Y h:i A')); ?></td>
                            <td>
                                <a class="me-3" href="<?php echo e(route('expenses.edit',$product->id)); ?>">
                                    <img src="<?php echo e(URL::to('')); ?>/public/assets/img/icons/edit.svg" alt="img">
                                </a>
                                <a  data-bs-target="#deletemodel<?php echo e($loop->index); ?>" data-bs-toggle="modal">
                                    <img src="<?php echo e(URL::to('')); ?>/public/assets/img/icons/delete.svg" alt="img">
                                </a>
                                <div class="modal fade" id="deletemodel<?php echo e($loop->index); ?>" tabindex="-1" aria-labelledby="deletemodel" aria-hidden="true">
                                    <div class="modal-dialog modal-md modal-dialog-centered">
                                        <div class="modal-content">
                                       
                                            <div class="modal-header">
                                                <h5 class="modal-title text-center">Are you sure?</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <div class="modal-footer text-center" style="justify-content: center;">
                                                <form method="POST" id="delete-form<?php echo e($product->id); ?>" action="<?php echo e(route('expenses.destroy',[$product->id])); ?>">
                                                <?php echo csrf_field(); ?> 
                                                <?php echo method_field('delete'); ?>
                                                <button type="submit" class="btn btn-submit">Confirm Delete</button>
                                                </form>
                                                <button type="button" class="btn btn-cancel" data-bs-dismiss="modal">Close</button>
                                            </div>
                                        
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <h6 class="text-center">Expense found 0</h6>
                        <?php endif; ?>
                    </tbody>
                    
                </table>
            
            </div>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('styles'); ?>

<?php $__env->stopPush(); ?>


<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {

$('.datanews').DataTable({
    "bFilter": true,
    "sDom": 'fBtlpi',
    'pagingType': 'numbers',
    "ordering": true,
    "select": true,
    
    "language": {
        search: ' ',
        sLengthMenu: '_MENU_',
        searchPlaceholder: "Search...",
        info: "_START_ - _END_ of _TOTAL_ items",
    },
    "buttons": [

        {
            extend: 'excel',
            title: 'Expanse List',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            }
        },
        {
            extend: 'pdfHtml5',
            title: 'Expanse List',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            },
        },
        {
            extend: 'csv',
            title: 'Expanse List',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            }
        },
    ],
    initComplete: (settings, json) => {
        $('.dataTables_filter').appendTo('#tableSearch');
        $('.dataTables_filter').appendTo('.search-input');
    },
   

    
});
} );
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/honicma1/demo1.everrivo.com/resources/views/backend/expenses/index.blade.php ENDPATH**/ ?>