@extends('layouts.app')

@section('content')
@php
$setting=DB::table('settings')->first();
@endphp
<div class="checkout-area pt-30 pb-30 ">
    <div class="container bg-white py-4">
        <div class="row " style="padding: 20px;">
            <div class="col-md-3 col-sm-12 col-xl-3 col-lg-3 p-4"
                style="height: fit-content;border:1px solid {{$setting->header_color}};border-radius: 30px;">
                <div class="text-center">
                    @if(Auth()->user()->photo == null)
                    <img src="{{URL::to('')}}/public/assets/blank-profile-picture-973460_960_720.webp" alt=""
                        style="width: 50px; height: 50px; border-radius: 50%;">
                    @else
                    <img src="{{URL::to('')}}/public/storage/user/{{Auth()->user()->photo}}" alt=""
                        style="width: 50px; height: 50px; border-radius: 50%;">
                    @endif
                </div><br>
                <h2 class="text-center">{{Auth()->user()->name}}</h2><br>
                <ul style="padding: 25px;">
                    <li><a href="{{route('user')}}">Dashboard </a></li>
                    <li><a href="{{ route('user.order')}}">Order List</a></li>
                    <li><a href="{{ route('user.payreq')}}">Payment Request </a></li>
                    <li><a href="{{ route('user.setting')}}">Settings </a></li>
                    <li><a href="{{ route('user.password')}}">Password </a></li>
                    <li> <a href="#" onclick="event.preventDefault();
                              document.getElementById('logout-form').submit();">Logout </a>
                        <form id="logout-form" action="{{route('logout')}}" method="POST" style="display: none;">
                            @csrf
                        </form>
                    </li>

                </ul>
            </div>
            <div class="col-md-9 col-sm-12 col-xl-9 col-lg-9 ">
                <h3 class="text-center p-4">Order List</h3><br>
                <div class="table-responsive">
                    <table class="table  datanew ">
                        <tr>
                            <th>Order ID</th>
                            <th>Product</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Payment Status</th>
                            <th>Payment Action</th>
                            <th>Invoice</th>
                        </tr>
                        @if(count($products)>0)
                        @foreach($products as $product)
                        @php
                        $orderdetails=DB::table('order_details')->where('order_id',$product->id)->get();
                        $productdetails=App\Models\Product::where('id',$product->id)->withTrashed()->get();
                        @endphp
                        <tr>
                            <td>{{$setting->order_prefix}}{{$product->id}}</td>
                            <td>
                                @foreach($orderdetails as $row)
                                @php
                                $productdetails=App\Models\Product::where('id',$row->product_id)->withTrashed()->first();
                                @endphp
                                <strong>{{$productdetails->title}}</strong> <br>
                                <small>@if(isset($row->color)) Color: {{$row->color}} @endif @if(isset($row->size))
                                    Size: {{$row->size}} @endif </small><br>
                                <small>Quantity: {{$row->quantity}}</small> <br>
                                @endforeach
                            </td>
                            <td>{{$product->total_amount-$product->discount}} </td>
                            <td>
                                <span style="text-transform: capitalize;">{{$product->status}}</span>
                            </td>
                            <td>
                                <span style="text-transform: capitalize;">{{$product->payment_status}}</span>

                            </td>
                            <td>
                                @if($product->payment_status != 'paid')
                                <a href="{{ route('paymentreqcxv', $product->id)}}">Make Payment</a>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('invoice.index', $product->id)}}" target="_blank"><i
                                        class="fa-solid fa-arrow-up-right-from-square"></i> Open</a><br>
                                <a href="{{ route('invoice.download', $product->id)}}"><i
                                        class="fa-solid fa-download"></i> Download</a>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <th class="text-center" colspan="7">No order found!!!</th>
                        </tr>
                        @endif
                        
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
@endpush
@push('styles')
<style>
input.form-control {
    background: lightgray;
    border-radius: 20px;
}

.active {
    font-weight: bold;
    color: green;
}
</style>
<style>
table {
    font-family: arial, sans-serif;
    border-collapse: collapse;
    width: 100%;
}

td,
th {
    border: 1px solid #dddddd;
    text-align: left;
    padding: 8px;
}

tr:nth-child(even) {
    background-color: #f3f3f3;
}
</style>
@endpush