@extends('layouts.app')
@php
$setting=DB::table('settings')->first();
@endphp
@section('meta')
<title>Search your product | {{$setting->website}}</title>
@endsection
@section('content')

<div class="product-area pt-20">
    <div class="container">
        @if($products)
        <div class="section-title-btn-wrap wow tmFadeInUp mb-35">
            <div class="section-title-1 section-title-hm2">
                <h2>{{$title}}</h2>
            </div>
        </div>
        @if(count($products) < 1 )
        <div class="section-title-btn-wrap wow tmFadeInUp mb-35">
            <div class="section-title-1 section-title-hm2">
                <h2>No products found!</h2>
            </div>
        </div>
        @endif



        <div class="row">
            <div class="col-lg-12">
                <div class="row">
                    @foreach($products as $naim)

                    <div class="col-xl-3 col-lg-4 col-md-4 col-6 col-sm-6">
                        <div class="single-product-wrap mb-20 wow tmFadeInUp bg-white shadow-sm">
                            <div class="product-img-action-wrap mb-10">
                                <div class="product-img product-img-zoom">
                                    <a href="{{route('product.view',$naim->slug)}}">
                                        <img class="default-img" loading="lazy"
                                            src="{{URL::to('')}}/{{$naim->photo}}"
                                            data-src="{{URL::to('')}}/{{$naim->photo}}"
                                            alt="">
                                    </a>
                                </div>
                                @if($naim->discount >0)
                                <div class="product-badges product-badges-position product-badges-mrg"><span
                                        class="red">{{$naim->discount}}
                                        %</span></div>
                                @endif
                            </div>
                            <div class="product-content-wrap px-2 pt-0 pb-2 px-2 pt-0 pb-2">
                                <h2><a href="{{route('product.view',$naim->slug)}}">{{$naim->title}}</a></h2>
                                <div class="product-price">
                                    <span class="new-price mr-2">৳{{$naim->offer_price}}</span>@if($naim->offer_price < $naim->price)<span class="old-price">{{$naim->price}}</span> @endif
                                        
                                </div>
                              
                  @if($naim->type=="single")
    @if($naim->stock > 0)
        <div class="d-flex justify-content-center mb-2 mt-3 your_choice">
            <a href="javascript:void(0);" class="button rounded-4 text-center text-rubik text-orange-carrot-orange homebuynowb" data-id="{{ $naim->id }}"><i class="fas fa-shopping-cart"></i> Order Now </a>
        </div>
    @else
        <label class="badge bg-danger">Out of stock</label>
    @endif
@else
    @if($naim->stock > 0)
        <div class="d-flex justify-content-center mb-2 mt-3 your_choice">
            <a href="{{route('product.view',$naim->slug)}}" class="button rounded-4 text-center text-rubik text-orange-carrot-orange homebuynowbv" data-id="{{ $naim->id }}" data-name="{{ $naim->title }}"><i class="fas fa-shopping-cart"></i> Order Now</a>
        </div>
    @else
        <label class="badge bg-danger">Out of stock</label>
    @endif
@endif
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        <div class="section-title-btn-wrap wow tmFadeInUp mb-35" style="justify-content: center;">
            <div class="btn-style-2 mrg-top-xs">
               {{$products->links("pagination::bootstrap-4")}}
            </div>
        </div>

        @endif
    </div>
</div>


@endsection

@push('styles')
@php
$setting=DB::table('settings')->first();
@endphp

<style>
    .page-item.active .page-link {
        background: {{$setting->header_color}};
        border-color: {{$setting->header_color}};
        color: {{$setting->header_text_color}};
    }
    .btn-style-2.mrg-top-xs {
        box-shadow: 0 .5rem 1rem rgba(0,0,0,.15)!important;
    }
</style>

@endpush