@extends('layouts.app')
@php
$setting=DB::table('settings')->first();
@endphp
@section('meta')
<title>{{$title}} | {{$setting->website}}</title>
@endsection
@section('content')

<div class="product-area pt-3">
    <div class="custom-container">
        @if($products)
        <div class="section-title-btn-wrap wow tmFadeInUp mb-10 category-base-color pd-5">
                <h3 class="pt-5 pl-2 text-center" style="font-weight: 600;color:black;">{{$title}}</h3>
        </div>
        

        <div class="custom-container">
            <div class="row row-cols-2 row-cols-lg-5 g-2 g-lg-3">
      @foreach($subcategory as $cat)
      <div class="col">
         <div class="category">
            <a href="{{route('product.category',$cat->slug)}}">
               <img src="{{URL::to('')}}/{{$cat->icon}}" alt="{{$cat->title}}" class="img-fluid">
               <div class="">
                  <h2 class="h-auto text-center font-weight-bold" style="font-weight: 600;color:{{$setting->home_category_text}};" >{{$cat->title}}</h2>
               </div>
            </a>
         </div>
      </div>
      @endforeach
      </div>
   </div>
   @if(count($products) < 1 )
        <div class="section-title-btn-wrap wow tmFadeInUp mb-35">
            <div class="section-title-1 section-title-hm2">
                <h2>No products found!</h2>
            </div>
        </div>
        @endif
</div> 

        

        <div class="row mt-10">
            <div class="col-lg-12">
            <div class="custom-container">
                <div class="row row-cols-2 row-cols-lg-5 g-2 g-lg-3">
                    @foreach($products as $row)
                    <div class="col">
                        <div class="single-product-wrap mb-20 wow tmFadeInUp bg-white shadow-sm">
                            <div class="product-img-action-wrap mb-10">
                                <div class="product-img product-img-zoom">
                                    <a href="{{route('product.view',$row->slug)}}">
                                        <img class="default-img" loading="lazy"
                                            src="{{URL::to('')}}/{{$row->photo}}"
                                            data-src="{{URL::to('')}}/{{$row->photo}}"
                                            alt="">
                                    </a>
                                </div>
                                @if($row->discount >0)
                                <div class="product-badges product-badges-position product-badges-mrg"><span
                                        class="red">{{$row->discount}}
                                        %</span></div>
                                @endif
                            </div>
                            <div class="product-content-wrap px-2 pt-0 pb-2 px-2 pt-0 pb-2">
                                <h2><a href="{{route('product.view',$row->slug)}}">{{$row->title}}</a></h2>
                                <div class="product-price">
                                    <span class="new-price mr-2">{{$row->offer_price}}</span> @if($row->offer_price < $row->price)<span class="old-price">{{$row->price}}</span> @endif
                                </div>
                               @if($row->type=="single")
    @if($row->stock > 0)
        <div class="d-flex justify-content-center mb-2 mt-3 your_choice">
            <a href="javascript:void(0);" class="button rounded-4 text-center text-rubik text-orange-carrot-orange homebuynowb" data-id="{{ $row->id }}"><i class="fas fa-shopping-cart"></i> Order Now</a>
        </div>
    @else
        <label class="badge bg-danger">Out of stock</label>
    @endif
@else
    @if($row->stock > 0)
        <div class="d-flex justify-content-center mb-2 mt-3 your_choice">
            <a href="{{route('product.view',$row->slug)}}" class="button rounded-4 text-center text-rubik text-orange-carrot-orange homebuynowbv" data-id="{{ $row->id }}" data-name="{{ $row->title }}"><i class="fas fa-shopping-cart"></i> Order Now</a>
        </div>
    @else
        <label class="badge bg-danger">Out of stock</label>
    @endif
@endif
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            </div>
        </div>
        <div class="section-title-btn-wrap wow tmFadeInUp mb-35" style="justify-content: center;">
            <div class="btn-style-2 mrg-top-xs">
               {{$products->links("pagination::bootstrap-4")}}
            </div>
        </div>

        @endif
    </div>
</div>


@endsection

@push('styles')


<style>
    .page-item.active .page-link {
        background: {{$setting->header_color}};
        border-color: {{$setting->header_color}};
        color: {{$setting->header_text_color}};
    }
    .btn-style-2.mrg-top-xs {
        box-shadow: 0 .5rem 1rem rgba(0,0,0,.15)!important;
    }

    .single-product-wrap .product-content-wrap h2{
        line-height: normal;
    }

</style>
<style>
            .category {
      position: relative;
      background-color: #fff;
      padding: 5px;
      overflow: hidden;
      border-radius: 5px !important;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
      border: 1px solid #ccc0 !important;
      margin-bottom: 0px !important;
      }
      .category img {
      width: 100%;
      height: 100%;
      border-radius: 5px;
      border-bottom: 1px solid #ddd;
      transition: filter 0.3s ease-in-out;
      }
      .category:hover img {
      filter: brightness(40%);
      }
      .category .category-name {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      opacity: 0;
      transition: opacity 0.3s ease-in-out;
      }
      .category:hover .category-name {
      opacity: 1;
      }
      .category h2 {
      padding: 10px;
      margin: 0;
      font-size: 1.0rem;
      text-align: center;
      color: yellow;
      font-weight: 800;
      }
        </style>
@endpush