@extends('backend.layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">POS - Point of Sale</div>

                <div class="card-body">
                    <div class="row mb-4">
                        @foreach ($products as $product)
                            <div class="col-md-4 mb-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title">{{ $product->title }}</h5>
                                        <p class="card-text">Price: ${{ $product->offer_price }}</p>
                                        <p class="card-text">Stock: {{ $product->stock }}</p>
                                        <p class="card-text">Color: {{ $product->color }}</p>
                                        <p class="card-text">Sizes: 
                                            @foreach ($product->sizeVariations as $variation)
                                                {{ $variation->size->name }} (${{ $variation->price }})
                                            @endforeach
                                        </p>
                                        <a href="javascript:void(0);" class="btn btn-primary add-to-order"
                                            data-id="{{ $product->id }}"
                                            data-title="{{ $product->title }}"
                                            data-price="{{ $product->offer_price }}"
                                            data-stock="{{ $product->stock }}"
                                            data-color="{{ $product->color }}"
                                            data-sizes="{{ json_encode($product->sizeVariations) }}">Add to Order</a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div id="order-items" class="card">
                                <div class="card-header">Order Items</div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Product</th>
                                                <th>Price</th>
                                                <th>Quantity</th>
                                                <th>Total</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="order-items-body">
                                            <!-- Order items will be dynamically added here -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12 text-right">
                            <h4>Total: $<span id="order-total">0.00</span></h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.add-to-order').click(function() {
            const productId = $(this).data('id');
            const productTitle = $(this).data('title');
            const productPrice = parseFloat($(this).data('price'));

            const existingRow = $(`#order-items-body tr[data-product-id=${productId}]`);

            if (existingRow.length > 0) {
                const quantityInput = existingRow.find('.quantity-input');
                const quantity = parseInt(quantityInput.val()) + 1;
                quantityInput.val(quantity);

                const total = quantity * productPrice;
                existingRow.find('.item-total').text(`$${total.toFixed(2)}`);
            } else {
                const newRow = `
                    <tr data-product-id="${productId}">
                        <td>${productTitle}</td>
                        <td>$${productPrice.toFixed(2)}</td>
                        <td><input type="number" class="form-control quantity-input" value="1" min="1"></td>
                        <td class="item-total">$${productPrice.toFixed(2)}</td>
                        <td><button class="btn btn-danger btn-sm remove-item">Remove</button></td>
                    </tr>
                `;
                $('#order-items-body').append(newRow);
            }

            updateOrderTotal();
        });

        $(document).on('click', '.remove-item', function() {
            $(this).closest('tr').remove();
            updateOrderTotal();
        });

        $(document).on('input', '.quantity-input', function() {
            const quantity = parseInt($(this).val());
            const price = parseFloat($(this).closest('tr').find('td:eq(1)').text().replace('$', ''));
            const total = quantity * price;
            $(this).closest('tr').find('.item-total').text(`$${total.toFixed(2)}`);

            updateOrderTotal();
        });

        function updateOrderTotal() {
            let total = 0;
            $('#order-items-body tr').each(function() {
                total += parseFloat($(this).find('.item-total').text().replace('$', ''));
            });

            $('#order-total').text(total.toFixed(2));
        }
    });
</script>
@endpush