@extends('layouts.app')
@php
$setting=DB::table('settings')->first();
@endphp
@section('meta')
<title>Order Confirmation | {{$setting->website}}</title>
@endsection
@section('content')

<div class="checkout-area pt-30 pb-30 ">
  <div class="custom-container bg-white py-4">
    <div class="row ">
      @if(session('error'))
          <div class="alert alert-danger alert-dismissable fade show" style="color:red; border:1px solid red;">
              {{session('error')}}
          </div><br><br>
      @endif
      <div class="col-md-12 text-center p-4">
        <h3 class="">অর্ডার ট্রাকিং নম্বর : {{$data->order_number}}</h3>
        <h3 class="">Total Amount : {{$data->total_amount}}</h3>
        @if($data->payment_status == 'paid' && $data->payment_method == 'bkash' && $data->trxid != null  )
        <h3 class="pb-3 text-success">{!!$setting->order_page!!} Payment Successful</h3>
        @elseif($data->payment_status == 'unpaid' && $data->payment_method == 'bkash')
        <h3 class="pb-3 text-success">{!!$setting->order_page!!} <span class="text-danger">Payment failed! You can pay again from your dashboard</span></h3>
        @elseif($data->payment_status == 'paid' && $data->payment_method == 'bank' && $data->bank_trxid != null  )
        <h3 class="pb-3 text-success">{!!$setting->order_page!!} Payment Successful</h3>
        @else
        <h3 class="pb-3 text-success">{!!$setting->order_page!!}</h3>
        @endif
        <a href="{{ route('shop')}}" class="base-color btn btn-success btn-block btn-lg" style="margin: 0 auto; border-radius: 3px; width: fit-content;color:white !important;">Browse more products</a>
      </div>
    </div>
  </div>
</div>
@endsection
@push('scripts')
@endpush
