@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>User  Edit</h4>

        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('user.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">


                <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" name="name" value="{{$data->name}}" required="required">
                            @error('name')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" value="{{$data->email}}" required="required">
                            @error('email')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Phone</label>
                            <input type="number" name="phone" value="{{$data->phone}}" required="required">
                            @error('phone')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" name="password" value="" >
                            @error('password')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>

                    @if(Auth()->user()->role == 'admin')
                    <input type="hidden" value="1" name="verified">
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Role</label>
                            <select name="role" id="role" class="form-control">
                                <option value="admin" @if($data->role == 'admin' ) selected @endif>Admin</option>
                                <option value="staff" @if($data->role == 'staff' ) selected @endif>Staff</option>
                                <option value="user" @if($data->role == 'user' ) selected @endif>User</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12 " id="roleplay" style="border: 1px solid lightgray;  margin-bottom: 20px; padding: 20px; flex-wrap: wrap; background: #f0f8ff40;@if($data->role == 'user' ) display:none;  @endif">
                        <div class="d-flex justify-content-start" style="flex-wrap: wrap;">
                            @php 
                                $acsdd = json_decode($data->access, true); ;
                            @endphp
                            <div class="form-check">
                                <input type="checkbox" name="access[]" checked @if(in_array('Dashboard', $acsdd)) checked @endif class="form-check-input" id="Dashboard" value="Dashboard">
                                <label class="form-check-label"  for="Dashboard">Dashboard</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" name="access[]" @if(in_array('Product', $acsdd)) checked @endif class="form-check-input" id="Product" value="Product">
                                <label class="form-check-label"  for="Product">Product</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" name="access[]" @if(in_array('Category', $acsdd)) checked @endif class="form-check-input" id="Category" value="Category">
                                <label class="form-check-label"  for="Category">Category</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" name="access[]" @if(in_array('Media', $acsdd)) checked @endif class="form-check-input" id="Media" value="Media">
                                <label class="form-check-label"  for="Media">File</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" name="access[]" @if(in_array('Order', $acsdd)) checked @endif class="form-check-input" id="Order" value="Order">
                                <label class="form-check-label"  for="Order">Order</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" name="access[]" @if(in_array('Pages', $acsdd)) checked @endif class="form-check-input" id="Pages" value="Pages">
                                <label class="form-check-label"  for="Pages">Pages</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" name="access[]" @if(in_array('Shipping', $acsdd)) checked @endif class="form-check-input" id="Shipping" value="Shipping">
                                <label class="form-check-label"  for="Shipping">Shipping</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" name="access[]" @if(in_array('Users', $acsdd)) checked @endif class="form-check-input" id="Users" value="Users">
                                <label class="form-check-label"  for="Users">Users</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" name="access[]" @if(in_array('BannersSetting', $acsdd)) checked @endif class="form-check-input" id="BannersSetting" value="BannersSetting">
                                <label class="form-check-label"  for="BannersSetting">Banners Setting</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" name="access[]" @if(in_array('API', $acsdd)) checked @endif class="form-check-input" id="API" value="API">
                                <label class="form-check-label"  for="API">API</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" name="access[]" @if(in_array('Settings', $acsdd)) checked @endif class="form-check-input" id="Settings" value="Settings">
                                <label class="form-check-label"  for="Settings">Settings</label>
                            </div>
                        </div>
                    </div>
                    @endif
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection
<style>
    .form-check {
    margin-right: 15px;
}
</style>
@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
$("#role").change(function() {
    if ($(this).find('option:selected').val()  === "user") {
      // If the "User" option is selected, hide the element with id "roleplay"
      $("#roleplay").hide();
    } else {
      // Otherwise, show the element with id "roleplay"
      $("#roleplay").show();
    }
  });
</script>

@endpush