@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>User  Add</h4>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('user.store')}}" method="POST" enctype="multipart/form-data">
                @CSRF
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" name="name" value="{{old('name')}}" required="required">
                            @error('name')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" value="{{old('email')}}" required="required">
                            @error('email')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Phone</label>
                            <input type="number" name="phone" value="{{old('phone')}}" required="required">
                            @error('phone')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" name="password" value="" required="required">
                            @error('price')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Confirm Password*</label>
                            <input type="password" name="password_confirmation" value="{{old('price')}}" required="required">
                            @error('password_confirmation')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <input type="hidden" value="1" name="verified">
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Role</label>
                            <select name="role" id="" class="form-control">
                                <option value="admin">Admin</option>
                                <option value="staff">Staff</option>
                                <option value="user">User</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12 d-flex justify-content-start" style="border: 1px solid lightgray; margin-bottom: 20px; padding: 20px; flex-wrap: wrap; background: #f0f8ff40;">
                        <div class="form-check">
                            <input type="checkbox" name="access[]" checked class="form-check-input" id="Dashboard" value="Dashboard">
                            <label class="form-check-label"  for="Dashboard">Dashboard</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="access[]" class="form-check-input" id="Product" value="Product">
                            <label class="form-check-label"  for="Product">Product</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="access[]" class="form-check-input" id="Category" value="Category">
                            <label class="form-check-label"  for="Category">Category</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="access[]" class="form-check-input" id="Media" value="Media">
                            <label class="form-check-label"  for="Media">File</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="access[]" class="form-check-input" id="Order" value="Order">
                            <label class="form-check-label"  for="Order">Order</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="access[]" class="form-check-input" id="Pages" value="Pages">
                            <label class="form-check-label"  for="Pages">Pages</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="access[]" class="form-check-input" id="Shipping" value="Shipping">
                            <label class="form-check-label"  for="Shipping">Shipping</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="access[]" class="form-check-input" id="Users" value="Users">
                            <label class="form-check-label"  for="Users">Users</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="access[]" class="form-check-input" id="API" value="API">
                            <label class="form-check-label"  for="API">API</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="access[]" class="form-check-input" id="BannersSetting" value="BannersSetting">
                            <label class="form-check-label"  for="BannersSetting">Banners Setting</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="access[]" class="form-check-input" id="Settings" value="Settings">
                            <label class="form-check-label"  for="Settings">Settings</label>
                        </div>
                    </div>


                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')
<style>
    .form-check {
    margin-right: 15px;
}
</style>
@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>

@endpush