@extends('backend.layouts.app')

@section('content')

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Supplier List</h4>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <a href="{{ route('suppliers.create') }}" class="btn btn-submit">Add Supplier</a>
            <br><br>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Action</th>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Address</th>
                            <th>Payment Info</th>
                            <th>Balance</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                    @if(count($suppliers) > 0)
                        @foreach($suppliers as $supplier)
                        <tr>
                            <td>
                                <a class="me-3" href="{{ route('suppliers.edit', $supplier->id) }}">
                                    <img src="{{ URL::to('public/assets/edit.svg') }}" style="max-width: 20px;">
                                </a>
                                <br>
                                <a data-bs-target="#deleteModal{{ $loop->index }}" data-bs-toggle="modal">
                                    <img src="{{ URL::to('public/assets/delete.svg') }}" style="max-width: 25px;">
                                </a>
                                <div class="modal fade" id="deleteModal{{ $loop->index }}" tabindex="-1" aria-labelledby="deleteModal" aria-hidden="true">
                                    <div class="modal-dialog modal-md modal-dialog-centered">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title text-center">Are you sure?</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <div class="modal-footer text-center" style="justify-content: center;">
                                                <form method="POST" id="delete-form{{ $supplier->id }}" action="{{ route('suppliers.destroy', [$supplier->id]) }}">
                                                    @csrf
                                                    @method('delete')
                                                    <button type="submit" class="btn btn-submit">Confirm Delete</button>
                                                </form>
                                                <button type="button" class="btn btn-cancel" data-bs-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                               {{ $supplier->name }}
                            </td>
                            <td>{{ $supplier->phone }}</td>
                            <td>{!! $supplier->address !!}</td>
                            <td>{!! $supplier->payment_info !!}</td>
                            <td>{{ $supplier->balance }}</td>
                            <td style="text-transform: capitalize;">{{ $supplier->status }}</td>
                        </tr>
                        @endforeach
                    @else
                        <h6 class="text-center">No Suppliers found! Please create suppliers.</h6>
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.3.2/css/buttons.dataTables.min.css">
@endpush

@push('scripts')
<script type="text/javascript" src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.3.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.3.2/js/buttons.html5.min.js"></script>

@endpush
