@extends('backend.layouts.app')

@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Stock Managements</h4>
        </div>
        
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
    </div>
    <div class="card">
        <div class="card-body">
            <div class="table-top">
                <div class="search-set">
                    <div class="search-input">
                        <a class="btn btn-searchset"><img src="{{URL::to('')}}/public/assets/img/icons/search-white.svg" alt="img"></a>
                    </div>
                </div>
               
            </div>
            <div class="table-responsive">
                <table class="table ns">
                    <thead>
                        <tr>
                            <th>Action</th>
                            <th>Product</th>
                            <th>Price</th>
                            <th>Sale price</th>
                            <th>Total Stock</th>
                            <th>Size Stock</th>
                        </tr>
                    </thead>
                    <tbody>
                    @if(count($products)>0)
                        @foreach($products as $product)  
              
                        <tr>
                              <td>
    <a data-bs-target="#createPurchaseModal{{ $loop->index }}" data-bs-toggle="modal">
        <button type="button" class="btn btn-sm btn-submit">Create Purchase</button>
    </a>
    <div class="modal fade" id="createPurchaseModal{{ $loop->index }}" tabindex="-1" aria-labelledby="createPurchaseModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-md modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-center">{{substr($product->title,0,25)}}...</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('stocks.update', $product->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf 
                        @method('PATCH')
                        
                        
                        
                        @php
                         $sizes =  App\Models\Size::all();
                         // Get size variations for the current product
                         $sizev =  App\Models\ProductSizeVariation::where('product_id', $product->id)->get();
                        @endphp

                        <div class="mb-3">
                            <label for="costPrice{{ $loop->index }}" class="form-label">Cost Price</label>
                            <input type="number" class="form-control" id="costPrice{{ $loop->index }}" name="cost" value="{{ $product->cost }}" required>
                            @error('cost')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="regularPrice{{ $loop->index }}" class="form-label">Regular Price</label>
                            <input type="number" class="form-control" id="regularPrice{{ $loop->index }}" name="price" value="{{ $product->price }}">
                            @error('price')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="salePrice{{ $loop->index }}" class="form-label">Sale Price</label>
                            <input type="number" class="form-control" id="salePrice{{ $loop->index }}" name="offer_price" value="{{ $product->offer_price }}" required>
                            @error('offer_price')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label for="stock{{ $loop->index }}" class="form-label">Stock</label>
                            <input type="number" min="0" class="form-control" id="stock{{ $loop->index }}" name="stock" value="{{ $product->stock }}" required>
                            @error('stock')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="mb-3">
    <div id="variable_table" class="col-md-12">
        <div class="table-responsive">
            <table id="size_table" class="table table-centered table-nowrap table-bordered text-center">
                <thead>
                    <tr>
                        <th>Size</th>
                        <th style="width: 20%;">Price</th>
                        <th style="width: 20%;">Stock</th>
                        <th width="5">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($sizev as $sizef)

                   @php 
                       $sizename = App\Models\Size::find($sizef->size_id); 
                   @endphp
                    <tr>
                        <td>
                            <div class="col-lg-12 col-sm-8 col-12">
                                <div class="form-group">
                                    <label>Size</label>
                                    <select class="select" name="size_id[]">
                                     <option value='{{$sizename->id}}' @if($sizef->id == $sizename->id) selected @endif>{{$sizename->name}}</option>
                                    </select>
                                </div>
                            </div>
                        </td>
                        <td>
                            <input class="form-control" type="number" name="size_price[]" value="{{$sizef->price}}" >
                        </td>
                        <td>
                            <input class="form-control" type="number" name="size_stock[]" value="{{$sizef->stock}}">
                        </td>
                        <td>
                            <button type="button" class="btn btn-danger btn-sm remove_row">Remove</button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="mb-3 pb-3 border-bottom text-center">
            <button type="button" class="btn btn-success hover-outline btn-icon btn-icon-start mt-2 add_more">Add More</button>
            </div></div>
    </div>
</div>

                        <div class="d-flex justify-content-center">
                            <button type="submit" class="btn btn-submit">Submit</button>
                            <button type="button" class="btn btn-cancel ms-2" data-bs-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</td>
                            <td>
                                <a class="product-img">
                                    <img src="{{URL::to('')}}{{$product->photo}}" alt="product">
                                </a>
                                {{substr($product->title,0,25)}}...
                            </td>
                            
                            <td>{{ $product->price}}</td>
                            <td>{{ $product->offer_price}}</td>
                            <td>
                               {{ $product->stock}}
                            </td>
                            <td>
                                
                                
                                @foreach($size_data[$product->id] as $size)
                                    <span style="border: 1px solid #006666;margin: 5px;padding: 3px;">{{ $size->size->name }}-{{ $size->stock }}</span>
                                @endforeach
                                
                            </td>
                        </tr>
                        @endforeach
                        @else
                        @endif
                    </tbody>
                    
                </table>
            
            </div>
        </div>
    </div>

</div>
@endsection
@push('styles')

@endpush


@push('scripts')
<script>
   $(document).ready(function() {
       // Add more rows
       $(".add_more").click(function() {
           var html = '<tr>' +
               '<td><select name="size_id[]" class="form-control">@foreach($sizes as $size)<option value="{{$size->id}}">{{ $size->name }}</option>@endforeach</select></td>' +
               '<td><input class="form-control" type="number" name="size_price[]" placeholder="Price"></td>' +
               '<td><input class="form-control" type="number" name="size_stock[]" placeholder="Stock"></td>' +
               '<td><button type="button" class="btn btn-danger btn-sm remove_row">Remove</button></td>' +
               '</tr>';
           $("#size_table tbody").append(html);
       });
   
       // Remove row
       $("body").on("click", ".remove_row", function() {
           $(this).closest("tr").remove();
       });
   });
</script>
@endpush