@extends('backend.layouts.app')

@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>SMS Setting List</h4>
            <h6>Manage your SMS Setting</h6>
        </div>
        <div class="page-btn">
            <a href="{{route('sms_template.create')}}" class="btn btn-added"><img src="{{URL::to('')}}/public/assets/img/icons/plus.svg" alt="img"
                    class="me-1">Add New SMS Template</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <div class="table-top">
                <div class="search-set">
                    <div class="search-input">
                        <a class="btn btn-searchset"><img src="{{URL::to('')}}/public/assets/img/icons/search-white.svg" alt="img"></a>
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>SMS For</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @if(count($products)>0)
                        @foreach($products as $product)   
              
                        <tr>
                            <td>
                                {{$product->id}}
                            </td>
                            <td>
                                {{$product->sms_for}}
                            </td>
                            <td>{{$product->status}}</td>
                            <td>
                                <a class="me-3" href="{{route('sms_template.edit',$product->id)}}">
                                    <img src="{{URL::to('')}}/public/assets/img/icons/edit.svg" alt="img">
                                </a>
                                <a  data-bs-target="#createpayment{{$product->id}}" data-bs-toggle="modal">
                                    <img src="{{URL::to('')}}/public/assets/img/icons/delete.svg" alt="img">
                                </a>
                                <div class="modal fade" id="createpayment{{$product->id}}" tabindex="-1" aria-labelledby="createpayment" aria-hidden="true">
                                    <div class="modal-dialog modal-md modal-dialog-centered">
                                        <div class="modal-content">
                                       
                                            <div class="modal-header">
                                                <h5 class="modal-title text-center">Are you sure?</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <div class="modal-footer text-center" style="justify-content: center;">
                                                <form method="POST" id="delete-form{{$product->id}}" action="{{route('sms_template.destroy',[$product->id])}}">
                                                @csrf 
                                                @method('delete')
                                                <button type="submit" class="btn btn-submit">Confirm Delete</button>
                                                </form>
                                                <button type="button" class="btn btn-cancel" data-bs-dismiss="modal">Close</button>
                                            </div>
                                        
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <h6 class="text-center">No phone found!!! Please create phone</h6>
                        @endif
                    </tbody>
                    
                </table>
            
            </div>
        </div>
    </div>

</div>
@endsection
@push('styles')

@endpush


@push('scripts')
<script>
$(document).ready(function() {

$('.datanews').DataTable({
    "bFilter": true,
    "sDom": 'fBtlpi',
    'pagingType': 'numbers',
    "ordering": true,
    "select": true,
    
    "language": {
        search: ' ',
        sLengthMenu: '_MENU_',
        searchPlaceholder: "Search...",
        info: "_START_ - _END_ of _TOTAL_ items",
    },
    "buttons": [
        {
            extend: 'csv',
            title: 'SMS List',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            }
        },
        {
            extend: 'excel',
            title: 'SMS List',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            }
        },
        {
            extend: 'pdfHtml5',
            title: 'SMS List',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            },
        },
    ],
    initComplete: (settings, json) => {
        $('.dataTables_filter').appendTo('#tableSearch');
        $('.dataTables_filter').appendTo('.search-input');
    },
   

    
});
} );
</script>
@endpush