@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Color Change</h4>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <form action="{{ route('website.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Base Color</label>
                            <input type="text" name="header_color" value="{{ $data->header_color }}" >
                            @error('header_color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Base Text Color</label>
                            <input type="text" name="header_text_color" value="{{ $data->header_text_color }}" >
                            @error('header_text_color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Top Header Color</label>
                            <input type="text" name="top_header_color" value="{{ $data->top_header_color }}" >
                            @error('top_header_color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Top Menu Header Color</label>
                            <input type="text" name="top_menu_header_color" value="{{ $data->top_menu_header_color }}" >
                            @error('top_menu_header_color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Home Page Buy Now Color</label>
                            <input type="text" name="home_buynow" value="{{ $data->home_buynow }}" >
                            @error('home_buynow')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Home Page Buy Now Text Color</label>
                            <input type="text" name="home_buynow_text" value="{{ $data->home_buynow_text }}" >
                            @error('home_buynow_text')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Home Page Category Background Color</label>
                            <input type="text" name="home_category_background" value="{{ $data->home_category_background }}" >
                            @error('home_category_background')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Home Page Category Text Color</label>
                            <input type="text" name="home_category_text" value="{{ $data->home_category_text }}" >
                            @error('home_category_text')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Buy Now Button Color</label>
                            <input type="text" name="buy_now_color" value="{{ $data->buy_now_color }}" >
                            @error('buy_now_color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Buy Now Button Text Color</label>
                            <input type="text" name="buy_now_text_color" value="{{ $data->buy_now_text_color }}" >
                            @error('buy_now_text_color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Add to Cart Color</label>
                            <input type="text" name="cart_color" value="{{ $data->cart_color }}" >
                            @error('cart_color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Add to Cart Text Color</label>
                            <input type="text" name="cart_text_color" value="{{ $data->cart_text_color }}" >
                            @error('cart_text_color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Landing Page Background Color</label>
                            <input type="text" name="lan_bk_color" value="{{ $data->lan_bk_color }}" >
                            @error('lan_bk_color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Landing Page Border Color</label>
                            <input type="text" name="lan_bor_color" value="{{ $data->lan_bor_color }}" >
                            @error('lan_bor_color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>
<script>
    (function($) {

$.fn.filemanager = function(type, options) {
    type = type || 'file';

    this.on('click', function(e) {
        var route_prefix = (options && options.prefix) ? options.prefix : '/filemanager';
        var target_input = $('#' + $(this).data('input'));
        var target_preview = $('#' + $(this).data('preview'));
        window.open(route_prefix + '?type=' + type, 'FileManager', 'width=900,height=600');
        window.SetUrl = function(items) {
            var file_path = items.map(function(item) {
                return item.url;
            }).join(',');

            var url = '{{url('/')}}';
            var myNewStr = file_path.replace(url, '');
            file_path = myNewStr;
            // set the value of the desired input to image url
            target_input.val('').val(file_path).trigger('change');

            // clear previous preview
            target_preview.html('');

            // set or change the preview image src
            items.forEach(function(item) {
                target_preview.append(
                    $('<img>').css('width', '5rem').attr('src', item.thumb_url)
                );
            });

            // trigger change event
            target_preview.trigger('change');
        };
        return false;
    });
}

})(jQuery);

var route_prefix = "{{ url('')}}/filemanager";
$('#lfm234').filemanager('', {
prefix: route_prefix
});
$('#lfm2345').filemanager('', {
prefix: route_prefix
});
$('#lfm2346').filemanager('', {
prefix: route_prefix
});
</script>
@endpush