@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Social Link Update</h4>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="card col-lg-10">
        <div class="card-body">
            <form action="{{ route('social.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Facebook</label>
                            <input type="text" name="facebook" value="{{ $data->facebook }}" >
                            @error('facebook')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Facebook Page iframe Code</label>
                            <input type="text" name="iframe" value="{{ $data->iframe }}" placeholder="Facebook Page iframe Code" >
                            @error('iframe')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Youtube</label>
                            <input type="text" name="youtube" value="{{ $data->youtube }}" >
                            @error('youtube')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Instagram</label>
                            <input type="text" name="instagram" value="{{ $data->instagram }}" >
                            @error('instagram')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Whatsapp</label>
                            <input type="text" name="whatsapp" value="{{ $data->whatsapp }}" >
                            @error('whatsapp')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>
<script>
    (function($) {

$.fn.filemanager = function(type, options) {
    type = type || 'file';

    this.on('click', function(e) {
        var route_prefix = (options && options.prefix) ? options.prefix : '/filemanager';
        var target_input = $('#' + $(this).data('input'));
        var target_preview = $('#' + $(this).data('preview'));
        window.open(route_prefix + '?type=' + type, 'FileManager', 'width=900,height=600');
        window.SetUrl = function(items) {
            var file_path = items.map(function(item) {
                return item.url;
            }).join(',');

            var url = '{{url('/')}}';
            var myNewStr = file_path.replace(url, '');
            file_path = myNewStr;
            // set the value of the desired input to image url
            target_input.val('').val(file_path).trigger('change');

            // clear previous preview
            target_preview.html('');

            // set or change the preview image src
            items.forEach(function(item) {
                target_preview.append(
                    $('<img>').css('width', '5rem').attr('src', item.thumb_url)
                );
            });

            // trigger change event
            target_preview.trigger('change');
        };
        return false;
    });
}

})(jQuery);

var route_prefix = "{{ url('')}}/filemanager";
$('#lfm234').filemanager('', {
prefix: route_prefix
});
$('#lfm2345').filemanager('', {
prefix: route_prefix
});
$('#lfm2346').filemanager('', {
prefix: route_prefix
});
</script>
@endpush