@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Analytics Edit</h4>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <form action="{{ route('analytics.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
            @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Facebook Pixel Code</label>
                            <textarea name="pixels" id="" cols="50" rows="150">{{ $data->pixels }}</textarea>
                            @error('pixels')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Google Analytics Code</label>
                            <textarea name="analytics" id="" cols="50" rows="150">{{ $data->analytics }}</textarea>
                            @error('analytics')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    
                    
                    
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection