@extends('backend.layouts.app')

@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
<div class="content" style="zoom:90%;">
    <div class="page-header">
        <div class="page-title">
            <h4>Sellers List</h4>
            <h6>Manage your Sellers</h6>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <div class="table-top">
                <div class="search-set">
                    <div class="search-input">
                        <a class="btn btn-searchset"><img src="{{URL::to('')}}/public/assets/img/icons/search-white.svg" alt="img"></a>
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Company Name</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>Current Address</th>
                            <th>Office Address</th>
                            <th>Trade License</th>
                            <th>Product Image</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @if(count($products)>0)
                        @foreach($products as $product)   
              
                        <tr>
                            <td>
                            {{$loop->index + 1}}
                            </td>
                            <td >
                                <a href="javascript:void(0);">{{$product->name}}</a>
                            </td>
                            <td>{{$product->company_name}}</td>
                            <td>{{$product->product_details}}</td>
                            <td>{{$product->phone}}</td>
                            <td>{{$product->current_address}}</td>
                            <td>{{$product->company_address}}</td>
                            <td><a href="{{URL::to('')}}/public/storage/trade_license/{{$product->trade_license}}" target="_blank"><img src="{{URL::to('')}}/public/storage/trade_license/{{$product->trade_license}}" alt="" style="width:100px;"></a></td>
                            <td><a href="{{URL::to('')}}/public/storage/product_image/{{$product->product_image}}" target="_blank"><img src="{{URL::to('')}}/public/storage/product_image/{{$product->product_image}}" alt="" style="width:100px;"></a></td>
                            <td>@if($product->status == 0) Unread @else Read @endif</td>
                            <td>
                                @if($product->status == 0)
                                <a href="{{ route('sellers.read', $product->id)}}" class="btn-sm btn-success text-white">Mark as Read</a><br><br>
                                @endif
                                <a  data-bs-target="#createpayment{{$loop->index}}" data-bs-toggle="modal">
                                    <img src="{{URL::to('')}}/public/assets/img/icons/delete.svg" alt="img">
                                </a>
                                <div class="modal fade" id="createpayment{{$loop->index}}" tabindex="-1" aria-labelledby="createpayment" aria-hidden="true">
                                    <div class="modal-dialog modal-md modal-dialog-centered">
                                        <div class="modal-content">
                                       
                                            <div class="modal-header">
                                                <h5 class="modal-title text-center">Are you sure?</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <div class="modal-footer text-center" style="justify-content: center;">
                                                <a href="{{ route('sellers.delete', $product->id)}}" class="btn btn-submit text-white">Confirm Delete</a>
                                                <button type="button" class="btn btn-cancel" data-bs-dismiss="modal">Close</button>
                                            </div>
                                        
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <h6 class="text-center">No resellers found!!! </h6>
                        @endif
                    </tbody>
                    
                </table>
            
            </div>
        </div>
    </div>

</div>
@endsection
@push('styles')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.3.2/css/buttons.dataTables.min.css">

@endpush


@push('scripts')
<script type="text/javascript" src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.3.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.3.2/js/buttons.html5.min.js"></script>

<script>
$(document).ready(function() {
    $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
} );
</script>
@endpush