@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Schedule  Add</h4>
            <h6>Create new Schedule</h6>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('schedule.store')}}" method="POST" enctype="multipart/form-data">
                @CSRF
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">



                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Schedule Title*</label>
                            <input type="text" name="title" value="{{old('title')}}" required="required">
                            @error('title')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Schedule Location*</label>
                            <input type="text" name="location" value="{{old('location')}}" required="required">
                            @error('location')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Schedule Time*</label>
                            <input type="text" name="time" value="{{old('time')}}" required="required">
                            @error('time')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Schedule Color*</label>
                            <input type="text" name="color" value="{{old('color')}}" required="required">
                            @error('color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Schedule Text Color*</label>
                            <input type="text" name="text_color" value="{{old('text_color')}}" required="required">
                            @error('text_color')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                 

                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>

@endpush