@extends('backend.layouts.app')
@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
@php 
$stat           = App\Models\StatusControl::get();
$totalorder = App\Models\Order::count();
$Placed_order = App\Models\Order::where('status','New Order')->count();
$Cancel_order = App\Models\Order::where('status','Cancel')->count();
$DeliveryDone = App\Models\Order::where('status','Delivery Done')->count();
$DeliveryDone = App\Models\Order::where('status','Confirm')->count();
$Confirm        = App\Models\StatusControl::where('status','Confirm')
@endphp
<div class="content">
   <div class="page-header">
      <div class="page-title">
         <h4>Order List</h4>
      </div>
      <div class="page-btn">
         <a href="{{route('order.create')}}" class="btn btn-added"><img src="{{URL::to('')}}/public/assets/img/icons/plus.svg" alt="img"
            class="me-1">Add Order</a>
      </div>
   </div>
   <div class="row">
      <div class="col-md-12">
         @include('backend.layouts.notification')
      </div>
   </div>
   <div class="row mb-3">
      <div class="col-md-12" id="statusRadioButtons">
         @foreach($stat as $status)
         <div class="btn-group" role="group" aria-label="Basic radio toggle button group">
            <input type="radio" class="btn-check order_sts" name="status" id="{{ $status->name }}" value="{{ $status->name }}" autocomplete="off">
            <label class="btn btn-outline-primary" for="{{ $status->name }}">{{ $status->name }} ({{ \App\Models\Order::where('status', $status->name)->count() }})</label>
         </div>
         @endforeach
      </div>
   </div>
   <div id="rcvd_order">
      <div class="card">
         <div class="card-body">
            <div class="table-top ">
               <form action="{{ route('sales.get')}}" method="POST" class="d-flex"> 
                  @csrf
                  <input type="text" class="form-control" name="search" id="searchitem">
                  <button type="submit" class="btn btn-searchset">
                  <img src="{{ URL::to('') }}/public/assets/img/icons/search.png" alt="img">
                  </button>
               </form>
               <a data-bs-target="#bulkStatusChangeModal" data-bs-toggle="modal">
               <button type="button" class="btn btn-danger mt-2">Status Change</button>
               </a>
               <div class="modal fade" id="bulkStatusChangeModal" tabindex="-1" aria-labelledby="bulkStatusChangeModal" aria-hidden="true">
                  <div class="modal-dialog modal-md modal-dialog-centered">
                     <div class="modal-content">
                        <div class="modal-header">
                           <h5 class="modal-title text-center">Bulk Status Change</h5>
                           <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                           <span aria-hidden="true">×</span>
                           </button>
                        </div>
                        <div class="modal-footer text-center" style="justify-content: center;">
                           <form id="bulkStatusChangeForm" action="{{ route('order.bulkStatusChange') }}" method="POST">
                              @csrf
                              <div class="modal-body">
                                 <div class="form-group">
                                    <label for="statusDropdown">Select Status:</label>
                                    <select class="form-control" id="statusDropdown" name="new_status">
                                       @foreach($stat as $asdf)
                                       <option value="{{$asdf->name}}">{{$asdf->name}}</option>
                                       @endforeach
                                    </select>
                                 </div>
                                 <!-- Hidden input to store selected order IDs -->
                                 <div class="get_inputst"></div>
                              </div>
                              <div class="modal-footer">
                                 <button type="submit" class="btn btn-success btn-sm">Change Status</button>
                                 <button type="button" class="btn btn-warning btn-sm" data-bs-dismiss="modal">Close</button>
                              </div>
                           </form>
                        </div>
                     </div>
                  </div>
               </div>
                <form action="{{ route('order.bulkPrints') }}" method="GET" class="desktop-icon" target="_blank">
                   @csrf       
                  <span class="get_bulkprint">
                  </span>
               <button class="btn btn-searchset" type="submit"> <img src="{{URL::to('')}}/public/assets/img/icons/printer.svg" alt="img"></button>
               </form>
               <div class="row mt-2">
                  <div class="col-12">
                     <div class="form-group mb-4">
                        <div class="dropdown">
                           <button class="btn btn-secondary bg-warning dropdown-toggle" style="background: rgb(230 230 230 / 0%);border: rgb(230 230 230 / 0%);" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                           Send Courier
                           </button>
                           <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton" style="background: rgb(230 230 230 / 0%);border: rgb(230 230 230 / 0%);" >
                              <form action="{{ route('OrderSendToPathao') }}" method="post" class="desktop-icon mb-2">
                                 @csrf       
                                 <span class="get_pathao">
                                 </span>
                                 <button class="btn btn-info" type="submit"> Send Pathao</button>
                              </form>
                              <form action="{{ route('createRedxParcel') }}" method="post" class="desktop-icon mb-2">
                                 @csrf       
                                 <span class="get_redx">
                                 </span>
                                 <button class="btn btn-warning" type="submit"> Send Redx</button>
                              </form>
                              <form action="{{ route('sendSteadFast') }}" method="post" class="desktop-icon mb-2">
                                 @csrf       
                                 <span class="get_inputs">
                                 </span>
                                 <button class="btn btn-primary" type="submit"> Send SteadFast</button>
                              </form>
                           </ul>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="table-responsive">
               <table class="table">
                  <thead>
                     <tr>
                        <th><input type="checkbox" id="checkedAll"></th>
                        <th>Action</th>
                        <th>ID</th>
                        <th>Date</th>
                        <th>C.Number</th>
                        <th>Customer Details</th>
                        <th>Status</th>
                        <th>Assign User</th>
                        <th>Other Info</th>
                     </tr>
                  </thead>
                  <tbody>
                     @if(count($products)>0)
                     @foreach($products as $product)
                     @php 
                     $orderdetails  =DB::table('order_details')->where('order_id',$product->id)->get();
                     $productdetails =DB::table('products')->where('id',$product->id)->get();
                     $username = DB::table('users')->where('id',$product->assign_user_id)->get();
                     @endphp
                     <tr>
                        <td><input class="checkSingle" type="checkbox" name="order_id[]" value="{{ $product->id }}"></td>
                        <td>
                           <a href="{{route('order.show',$product->id)}}">
                           <img src="{{URL::to('')}}/public/assets/view.svg"style="max-width: 20px;">
                           </a>
                           <br>
                           <a href="{{route('order.edit',$product->id)}}">
                           <img src="{{URL::to('')}}/public/assets/edit.svg"style="max-width: 20px;">
                           </a>
                           <br>
                           <a data-bs-target="#createpayment{{$loop->index}}" data-bs-toggle="modal">
                           <img src="{{URL::to('')}}/public/assets/delete.svg"style="max-width: 20px;">
                           </a>
                           
                           <div class="modal fade" id="createpayment{{$loop->index}}" tabindex="-1" aria-labelledby="createpayment" aria-hidden="true">
                              <div class="modal-dialog modal-md modal-dialog-centered">
                                 <div class="modal-content">
                                    <div class="modal-header">
                                       <h5 class="modal-title text-center">Are you sure?</h5>
                                       <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                       <span aria-hidden="true">×</span>
                                       </button>
                                    </div>
                                    <div class="modal-footer text-center" style="justify-content: center;">
                                       <form method="POST" id="delete-form{{$product->id}}" action="{{route('order.destroy',[$product->id])}}">
                                          @csrf 
                                          @method('delete')
                                          <button type="submit" class="btn btn-submit">Confirm Delete</button>
                                       </form>
                                       <button type="button" class="btn btn-cancel" data-bs-dismiss="modal">Close</button>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </td>
                        <td>
                           {{$settings->order_prefix}}{{$product->id}}
                        </td>
                        <td>
                           {{$product->created_at->format('h:i A')}}, <br>{{$product->created_at->format('Y-m-d')}}
                        </td>
                        <td>
                           @if($product->ip_address != null)(<?php
                              $customer_order_number = DB::table('orders')->where('ip_address', $product->ip_address)->count() ;
                              echo $customer_order_number ;
                              ?>) Ip: {{$product->ip_address}} @endif<br>
                           (<?php
                              $customer_phone_number = DB::table('orders')->where('phone', $product->phone)->count() ;
                              echo $customer_phone_number ;
                              ?>) Phone: {{$product->phone}}
                        </td>
                        <td>
                           {{$product->first_name}}
                           <div class="text-wrap"style="width: 9rem;">{{$product->address}}</div>
                           {{$product->phone}}<br>
                           Amount: {{$product->total_amount-$product->discount}}
                        </td>
                        <td>
                           @if($product->status == 'Cancel')
                           <span class="badge bg-danger" style="padding: 7px;">{{$product->status}}</span>
                           @endif
                           @if($product->status == 'New Order')
                           <span class="badge bg-info" style="padding: 7px;">{{$product->status}}</span> 
                           @endif
                           @if($product->status == 'Confirm')
                           <span class="badge bg-success" style="padding: 7px;">{{$product->status}}</span> 
                           @endif
                           @if($product->status == 'Shipped to Courier')
                           <span class="badge bg-warning" style="padding: 7px;">{{$product->status}}</span> 
                           @endif
                           @if($product->status == 'Delivery Done')
                           <span class="badge bg-primary" style="padding: 7px;">{{$product->status}}</span> 
                           @endif
                           @if($product->status == 'On Hold')
                           <span class="badge bg-dark" style="padding: 7px;">{{$product->status}}</span> 
                           @endif
                           @if($product->status == 'Return')
                           <span class="badge bg-secondary" style="padding: 7px;">{{$product->status}}</span> 
                           @endif
                           <a class="action-set" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false">
                           <i class="fa fa-ellipsis-v" aria-hidden="true"></i>
                           </a>
                           <ul class="dropdown-menu" style="">
                              @foreach($stat as $asdf)
                              <li>
                                 <a href="{{route('sales.status', [$product->id,$asdf->name]) }}" class="dropdown-item">{{$asdf->name}}</a>
                              </li>
                              @endforeach
                              <li>
                                 <a href="{{route('sales.status', [$product->id,'Delivery Done']) }}" class="dropdown-item">Delivery Done</a>
                              </li>
                              <li>
                                 <a href="{{route('sales.status', [$product->id,'Cancel']) }}" class="dropdown-item">Cancel</a>
                              </li>
                           </ul>
                        </td>
                        <td>
                           @foreach($username as $usernamee)
                           {{$usernamee->name}}
                           @endforeach
                        </td>
                        <td>
                           Pay Status: <b>{{$product->payment_status}}<b> <br>
                           <p style="white-space: initial;"> @if($product->note != null)Note : {{$product->note}} @endif </p>
                           @if($product->courier_tracking_id != null)Tracking id: {{$product->courier_tracking_id}} @endif   <br>
                        </td>
                     </tr>
                     @endforeach
                     @else
                     @endif
                  </tbody>
               </table>
               <br>
               <nav aria-label="Page navigation example">
                  {{$products->links("pagination::bootstrap-4")}}
               </nav>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection
@push('styles')
<style>
   small{
   font-size: 11px;
   color: #787676;
   }
   .form-group{
   margin-bottom:0px;
   }
</style>
@endpush
@push('scripts')
<script>
   $(document).ready(function() {
   $("#checkedAll").change(function(){
       $(".checkSingle").prop('checked', this.checked);
       updateSelectedOrders();
   });
   
   $(".checkSingle").click(function () {
       updateSelectedOrders();
   });
   
   function updateSelectedOrders() {
       let selectedOrders = $('input:checkbox:checked').length;
       $('#selected').text(selectedOrders);
       
       $(".get_inputs").empty();
       $('input:checkbox[class=checkSingle]:checked').each(function () {
           $(".get_inputs").append(`<input type="hidden" name="print_order_id[]" value="${this.value}">`);
       });
   
       $(".get_redx").empty();
       $('input:checkbox[class=checkSingle]:checked').each(function () {
           $(".get_redx").append(`<input type="hidden" name="print_order_id_get_redx[]" value="${this.value}">`);
       });
   
       $(".get_pathao").empty();
       $('input:checkbox[class=checkSingle]:checked').each(function () {
           $(".get_pathao").append(`<input type="hidden" name="print_order_id_get_pathao[]" value="${this.value}">`);
       });
       
       $(".get_bulkprint").empty();
       $('input:checkbox[class=checkSingle]:checked').each(function () {
           $(".get_bulkprint").append(`<input type="hidden" name="bulk_print_order_id[]" value="${this.value}">`);
       });
       
       
   }
   
   });
   
</script>
<script>
   $(document).ready(function(){
       $('.order_sts').on('click', function(){
           getOrderList();
       });
   
       function getOrderList() {
           var statusValue = $("input[name='status']:checked").val();
          // console.log('Status Value:', statusValue); // Log the status value
   
           $.ajax({
               type: 'GET',
               url: "{{ route('status_wise_order') }}",
               data: {status: statusValue},
               success: function(res) {
                   if(res.success === true) {            
                       $('#rcvd_order').html(res.view);             	
                   } else {
                       console.error('Error in success response:', res);
                   }
               },
               error: function(xhr, status, error) {
                   console.error('AJAX Error:', status, error);
                   console.log('Response:', xhr.responseText);
               }
           });
       }
   });
   
   
</script>
<script>
   $(document).ready(function() {
     $('#bulkStatusChangeForm').submit(function(event) {
       // Prevent default form submission
       event.preventDefault();
   
       // Get selected status
       var newStatus = $('#statusDropdown').val(); // Retrieve the selected value from the dropdown
   
       // Get selected order IDs
       var selectedOrderIds = $('input:checkbox[class=checkSingle]:checked').map(function() {
         return $(this).val();
       }).get();
   
       // Populate hidden inputs with order IDs
       $('.get_inputs').empty();
       selectedOrderIds.forEach(function(orderId) {
         $('.get_inputst').append(`<input type="hidden" name="order_ids[]" value="${orderId}">`);
       });
   
       // Add hidden input for new status
       $('.get_inputst').append(`<input type="hidden" name="new_status" value="${newStatus}">`);
   
       // Submit the form
       $(this).unbind('submit').submit();
     });
   });
</script>
@endpush

