@extends('backend.layouts.app')

@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Review List</h4>
            <h6>Manage your Review</h6>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <div class="table-top">
                <div class="search-set">
                    <div class="search-input">
                        <a class="btn btn-searchset"><img src="{{URL::to('')}}/public/assets/img/icons/search-white.svg" alt="img"></a>
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Product Name</th>
                            <th>Star</th>
                            <th>Comment</th>
                            <th>Status</th>
                            <th class="noExport">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @if(count($products)>0)
                        @foreach($products as $product)   
                            @php 
                                $finduser = \App\Models\Product::where('id', $product->product_id)->first();
                            @endphp
                        <tr>
                            <td>
                                {{$product->id}}
                            </td>
                            <td>
                                <a href="javascript:void(0);">{{$finduser->title}}</a>
                            </td>
                            <td>{{$product->rate}}</td>
                            <td>{{$product->review}}</td>
                            <td>@if($product->status == '1') <a class="btn-sm btn-success text-white" href="{{ route('reviews.active', $product->id )}}">Active</a>  @else <a href="{{ route('reviews.active', $product->id )}}" class="btn-sm btn-warning text-dark">Inactive</a>  @endif</td>
                            <td>
                                <a  data-bs-target="#createpayment{{$loop->index}}" data-bs-toggle="modal">
                                    <img src="{{URL::to('')}}/public/assets/img/icons/delete.svg" alt="img">
                                </a>
                                
                                <div class="modal fade" id="createpayment{{$loop->index}}" tabindex="-1" aria-labelledby="createpayment" aria-hidden="true">
                                    <div class="modal-dialog modal-md modal-dialog-centered">
                                        <div class="modal-content">
                                       
                                            <div class="modal-header">
                                                <h5 class="modal-title text-center">Are you sure?</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <div class="modal-footer text-center" style="justify-content: center;">
                                                <form method="POST" id="delete-form{{$product->id}}" action="{{route('reviews.delete',[$product->id])}}">
                                                @csrf 
                                                @method('delete')
                                                <button type="submit" class="btn btn-submit">Confirm Delete</button>
                                                </form>
                                                <button type="button" class="btn btn-cancel" data-bs-dismiss="modal">Close</button>
                                            </div>
                                        
                                        </div>
                                    </div>
                                </div></td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="6" class="text-center">No user found!!! Please create user</td>
                        </tr>
                        @endif
                    </tbody>
                    
                </table>
            
            </div>
        </div>
    </div>

</div>
@endsection
@push('styles')

@endpush


@push('scripts')

@endpush