@extends('backend.layouts.app')

@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
@php 
    $stat           = App\Models\StatusControl::get();
    $totalorder     = App\Models\Order::count();
    $Placed_order   = App\Models\Order::where('status','New Order')->count();
    $Cancel_order   = App\Models\Order::where('status','Cancel')->count();
    $DeliveryDone   = App\Models\Order::where('status','Delivery Done')->count();
    $Confirm        = App\Models\StatusControl::where('status','Confirm')
@endphp
@php
$totalQuantity = 0;
@endphp

@if(isset($data))
@foreach($data as $product)
@php
$totalQuantity += $product['quantity'];
@endphp
@endforeach
@endif
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Report</h4>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="row card" style="padding:20px;">
        <form action="{{route('report.date')}}" class="row" method="POST">
            @CSRF
            <div class="col-lg-3 col-sm-6 col-12">
                <div class="form-group ">
                    <label>Search Date </label>
                    <div class="input-groupicon">
                        <input type="text" placeholder="DD-MM-YYYY"  value="{{$fromDate}}"name="fromDate" class="datetimepicker">
                        <div class="addonset">
                        <img src="{{URL::to('')}}/public/assets/img/icons/calendars.svg" alt="img">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6 col-12">
                <div class="form-group ">
                    <label>Search Date </label>
                    <div class="input-groupicon">
                        <input type="text" placeholder="DD-MM-YYYY" name="todate" value="{{$todate}}" class="datetimepicker">
                        <div class="addonset">
                        <img src="{{URL::to('')}}/public/assets/img/icons/calendars.svg" alt="img">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6 col-12">
            <div class="form-group">
    <label>Status</label>
    <select name="status" class="form-control">
        @foreach($stat as $asdf)
            <option value="{{ $asdf->name }}" {{ $statusNew == $asdf->name ? 'selected' : '' }}>{{ $asdf->name }}</option>
        @endforeach
        <option value="Delivery Done" {{ $statusNew == 'Delivery Done' ? 'selected' : '' }}>Delivery Done</option>
        <option value="Cancel" {{ $statusNew == 'Cancel' ? 'selected' : '' }}>Cancel</option>
    </select>
</div>

        </div>
            <div class="col-12">
            <button type="submit" class="btn btn-success">
                Search
            </button>
            </div>
        </form>
    </div>
    <br>
    <div class="card">
        <div class="card-body">
            <div class="table-top">
                <div class="search-set">
                    <div class="search-input">
                        <a class="btn btn-searchset"><img src="{{URL::to('')}}/public/assets/img/icons/search-white.svg" alt="img"></a>
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table  datanew ">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Product Name</th>
                            <th>SKU</th>
                            <th>Size</th>
                            <th>Color</th>
                            <th>Quantity</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(isset($data))
                        @foreach($data as $product)   
                        <tr>
                            <td>{{$loop->index+1}}</td>
                            <td>{{$product['product_name']}}</td>
                            <td>{{$product['sku']}}</td>
                            <td>{{$product['size']}}</td>
                            <td>{{$product['color']}}</td>
                            <td>{{$product['quantity']}}</td>
                        </tr>
                        @endforeach
                        
                        @else
                        
                        <tr>
                            <td colspan="6" class="text-center">No order found!!!</td>
                        </tr>
                        @endif
                        <tfoot>
    <tr>
        
        <td colspan="6" class="text-align-right"style="color: red;text-align: center;font-size: x-large;">
            Total Sell: {{ $totalQuantity }}
        </td>
        
    </tr>
</tfoot>
                    </tbody>
                    
                </table>
            </div>
        </div>
    </div>

</div>
@endsection
@push('styles')

@endpush


@push('scripts')

@endpush