@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Edit Page</h4>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('pages.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Page Name</label>
                            <input type="text" name="title" value="{{ $data->title }}" required="required">
                            @error('title')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label>Description</label>
                            <textarea class="form-control" id="description" name="description">{!!$data->description!!}</textarea>
                            @error('description')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<!-- Place the first <script> tag in your HTML's <head> -->
<script src="https://cdn.tiny.cloud/1/73oa6gis2p3f8wrp5aju1844h7k7vhmpzwj9jn2egsq9xoiw/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>

<!-- Place the following <script> and <textarea> tags your HTML's <body> -->
<script>
  tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
  });
</script>

@endpush