@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Landing Page  Edit</h4>
            <h6>Edit Landing Page</h6>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('landings.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">



                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Page Title</label>
                            <input type="text" name="title" value="{{ $data->title }}" required="required">
                            @error('title')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <label class="col-form-label col-lg-2">Page Slug</label>
                        <div class="form-group row">
                            <div class="col-lg-12">
                                <div class="input-group">
                                    <span class="input-group-text" id="basic-addon3">{{url('/')}}/landing/</span>
                                    <input type="text" class="form-control" id="basic-url"
                                        aria-describedby="basic-addon3" name="slug" value="{{ $data->slug }}"
                                        required="required">
                                </div>
                            </div>
                            @error('slug')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label>Long Dis</label>
                            <textarea class="form-control" id="description" name="description">{{ $data->description }}</textarea>
                            @error('description')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label>Quality Assurance</label>
                            <textarea class="form-control" id="title2" name="title2">{{ $data->title2 }}</textarea>
                            @error('title2')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Video Url</label>
                            <input type="text" name="video_url" value="{{ $data->video_url }}" required="required">
                            @error('video_url')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Product Overview</label>
                            <input type="text" name="des1" value="{{ $data->des1 }}" required="required">
                            @error('des1')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Slider Top Text</label>
                            <input type="text" name="feature" value="{{ $data->feature }}" required="required">
                            @error('feature')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <label> Product Image (Single Image Only)</label>
                        <div class="input-group">
                            <span class="input-group-btn">
                                <a id="lfm23434" data-input="thumbnail3334" data-preview="holder3435" class="btn btn-primary">
                                    <i class="fa fa-picture-o"></i> Choose
                                </a>
                            </span>
                            <input id="thumbnail3334" class="form-control" name="image" value="{{ $data->image }}" type="text" >
                        </div>
                        <div id="holder3435" style="margin-top:15px;max-height:100px;">
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Product Name</label>
                            <input type="text" name="product_name" value="{{ $data->product_name }}" required="required">
                            @error('product_name')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Old Price</label>
                            <input type="text" name="old_price" value="{{ $data->old_price }}" required="required">
                            @error('old_price')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>New Price</label>
                            <input type="text" name="new_price" value="{{ $data->new_price }}" required="required">
                            @error('new_price')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Phone Number</label>
                            <input type="text" name="phone" value="{{ $data->phone }}" required="required">
                            @error('phone')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Feature</label>
                            <input type="text" name="des3" value="{{ $data->des3 }}" required="required">
                            @error('des3')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
 
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Product*</label>
                            <select class="select" name="product_id[]" multiple>
                                <option>Choose Prduct</option>
                                @foreach($products as $key=>$pro_data)
                                <option value='{{$pro_data->id}}'>{{$pro_data->title}}</option>
                                @php
                                $products=DB::table('products')->where('id')->get();
                                @endphp
                                @foreach($products as $row)
                                <option value='{{$row->id}}'>-{{$row->title}}</option>
                                @endforeach
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>
                          </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>

@endpush