@extends('backend.layouts.app')

@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Expense</h4>
        </div>
        <div class="page-btn">
            <a href="{{route('expenses.create')}}" class="btn btn-added"><img src="{{URL::to('')}}/public/assets/img/icons/plus.svg" alt="img"
                    class="me-1">Create Expense</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="row card" style="padding:20px;">
        <form action="{{route('expenses.search')}}" class="row" method="POST">
            @CSRF
            <div class="col-lg-3 col-sm-6 col-12">
                <div class="form-group ">
                    <div class="input-groupicon">
                        <input type="text" placeholder="DD-MM-YYYY"  value="{{$fromDate}}"name="fromDate" class="datetimepicker">
                        <div class="addonset">
                        <img src="{{URL::to('')}}/public/assets/img/icons/calendars.svg" alt="img">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6 col-12">
                <div class="form-group ">
                    <div class="input-groupicon">
                        <input type="text" placeholder="DD-MM-YYYY" name="todate" value="{{$todate}}" class="datetimepicker">
                        <div class="addonset">
                        <img src="{{URL::to('')}}/public/assets/img/icons/calendars.svg" alt="img">
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-sm-6 col-12">
            <button type="submit" class="btn btn-success">
                Search
            </button>
            </div>
        </form>
    </div>
    <br>
    <div class="card">
        <div class="card-body">
            <div class="table-top">
                <div class="search-set">
                    <div class="search-input">
                        <a class="btn btn-searchset"><img src="{{URL::to('')}}/public/assets/img/icons/search-white.svg" alt="img"></a>
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Amount</th>
                            <th>Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @if(count($data)>0)
                        @foreach($data as $product)   
                        <tr>
                            <td>{{$loop->index+1}}</td>
                            <td>{{$product->title}}</td>
                            <td>{{$product->description}}</td>
                            <td>{{$product->amount}}</td>
                            <td>{{$product->created_at->format('d-m-Y h:i A')}}</td>
                            <td>
                                <a class="me-3" href="{{route('expenses.edit',$product->id)}}">
                                    <img src="{{URL::to('')}}/public/assets/img/icons/edit.svg" alt="img">
                                </a>
                                <a  data-bs-target="#deletemodel{{$loop->index}}" data-bs-toggle="modal">
                                    <img src="{{URL::to('')}}/public/assets/img/icons/delete.svg" alt="img">
                                </a>
                                <div class="modal fade" id="deletemodel{{$loop->index}}" tabindex="-1" aria-labelledby="deletemodel" aria-hidden="true">
                                    <div class="modal-dialog modal-md modal-dialog-centered">
                                        <div class="modal-content">
                                       
                                            <div class="modal-header">
                                                <h5 class="modal-title text-center">Are you sure?</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <div class="modal-footer text-center" style="justify-content: center;">
                                                <form method="POST" id="delete-form{{$product->id}}" action="{{route('expenses.destroy',[$product->id])}}">
                                                @csrf 
                                                @method('delete')
                                                <button type="submit" class="btn btn-submit">Confirm Delete</button>
                                                </form>
                                                <button type="button" class="btn btn-cancel" data-bs-dismiss="modal">Close</button>
                                            </div>
                                        
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <h6 class="text-center">Expense found 0</h6>
                        @endif
                    </tbody>
                    
                </table>
            
            </div>
        </div>
    </div>

</div>
@endsection
@push('styles')

@endpush


@push('scripts')
<script>
$(document).ready(function() {

$('.datanews').DataTable({
    "bFilter": true,
    "sDom": 'fBtlpi',
    'pagingType': 'numbers',
    "ordering": true,
    "select": true,
    
    "language": {
        search: ' ',
        sLengthMenu: '_MENU_',
        searchPlaceholder: "Search...",
        info: "_START_ - _END_ of _TOTAL_ items",
    },
    "buttons": [

        {
            extend: 'excel',
            title: 'Expanse List',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            }
        },
        {
            extend: 'pdfHtml5',
            title: 'Expanse List',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            },
        },
        {
            extend: 'csv',
            title: 'Expanse List',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            }
        },
    ],
    initComplete: (settings, json) => {
        $('.dataTables_filter').appendTo('#tableSearch');
        $('.dataTables_filter').appendTo('.search-input');
    },
   

    
});
} );
</script>
@endpush