@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Coupon  Edit</h4>
            <h6>Edit Coupon</h6>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('coupon.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">

                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Coupon Code*</label>
                            <input type="text" name="code" value="{{ $data->code }}" required="required">
                            @error('code')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Coupon Price*</label>
                            <input type="number" name="value" value="{{ $data->value }}" required="required">
                            @error('value')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                   
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>

@endpush