@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Cateogry Edit</h4>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('category.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Category Name</label>
                            <input type="text" name="title" value="{{ $data->title }}" required="required">
                            @error('title')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <input type="hidden" value="{{ $data->slug }}" id="basic-url" name="slug">
                    <div class="col-lg-4 col-sm-6 col-12">
                        <div class="form-group">
                            <label>Parent Category?</label>
                            <select class="select" name="is_parent" id="is_parent">
                                <option value="1" @if( $data->is_parent == 1 )  selected @endif>Yes</option>
                                <option value="0" @if( $data->is_parent == 0 )  selected @endif>No</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-sm-12 col-12" id="parent_id" @if( $data->is_parent == 1 ) style="display:none;" @endif>
                        <div class="form-group">
                            <label>Child Category</label>
                            <select class="select" name="parent_id" >
                                <option>Choose Child Category</option>
                                @foreach($category as $cat_data)
                                <option value='{{$cat_data->id}}' @if( $data->parent_id  == $cat_data->id )  selected @endif>{{$cat_data->title}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-6 col-12">
                        <div class="form-group">
                            <label> Status</label>
                            <select class="select" name="status">
                                <option value="active" @if( $data->status == 'active' )  selected @endif>Active</option>
                                <option value="inactive" @if( $data->status == 'inactive' )  selected @endif>Inactive</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label>Description</label>
                            <textarea class="form-control" rows="4" cols="50" id="summary" name="summary">{!!$data->summary!!}</textarea>
                            @error('summary')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <label>Icon (Size: 300*300)</label>
                        <div class="input-group">
                            <span class="input-group-btn">
                                <a id="lfm234" data-input="thumbnail" data-preview="holder" class="btn btn-primary">
                                    <i class="fa fa-picture-o"></i> Choose
                                </a>
                            </span>
                            <input id="thumbnail" class="form-control" name="icon" value ="{{$data->icon}}" type="text" >
                        </div>
                        <div id="holder" style="margin-top:15px;max-height:100px;">
                                <img src="{{URL::to('')}}/{{$data->icon}}" alt="" style="width: 5rem;">
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<!-- Place the first <script> tag in your HTML's <head> -->
<script src="https://cdn.tiny.cloud/1/73oa6gis2p3f8wrp5aju1844h7k7vhmpzwj9jn2egsq9xoiw/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>

<!-- Place the following <script> and <textarea> tags your HTML's <body> -->
<script>
  tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
  });
</script>
<script type="text/javascript">
(function($) {

    $.fn.filemanager = function(type, options) {
        type = type || 'file';

        this.on('click', function(e) {
            var route_prefix = (options && options.prefix) ? options.prefix : '/filemanager';
            var target_input = $('#' + $(this).data('input'));
            var target_preview = $('#' + $(this).data('preview'));
            window.open(route_prefix + '?type=' + type, 'FileManager', 'width=900,height=600');
            window.SetUrl = function(items) {
                var file_path = items.map(function(item) {
                    var url = '{{url('/')}}';
                    var myNewStr = item.url.replace(url, '');
                    return myNewStr;
                }).join(',');

                var url = '{{url('/')}}';
                var myNewStr = file_path.replace(url, '');
                file_path = myNewStr;
                // set the value of the desired input to image url
                target_input.val('').val(file_path).trigger('change');

                // clear previous preview
                target_preview.html('');

                // set or change the preview image src
                items.forEach(function(item) {
                    target_preview.append(
                        $('<img>').css('width', '5rem').attr('src', item.thumb_url)
                    );
                });

                // trigger change event
                target_preview.trigger('change');
            };
            return false;
        });
    }

})(jQuery);

var route_prefix = "{{ url('')}}/filemanager";
$('#lfm234').filemanager('', {
    prefix: route_prefix
});
$('#lfmcxvb234').filemanager('', {
    prefix: route_prefix
});
</script>
<script type="text/javascript">


$('#is_parent').on('change', function (e) {
    let yesorno = parseFloat( $(this).find('option:selected').val() ) || 0;
    if(yesorno == 1){
        $('#parent_id').hide();
    }
    else{
        $('#parent_id').show();
    }
});
</script>
@endpush