@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Carrier  Edit</h4>
            <h6>Edit Carrier</h6>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('career.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">



                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Carrier Name*</label>
                            <input type="text" name="title" value="{{ $data->title }}" required="required">
                            @error('title')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12">
                        <label class="col-form-label col-lg-2">Carrier Slug*</label>
                        <div class="form-group row">
                            <div class="col-lg-12">
                                <div class="input-group">
                                    <span class="input-group-text" id="basic-addon3">{{url('/')}}/carrier/</span>
                                    <input type="text" class="form-control" id="basic-url"
                                        aria-describedby="basic-addon3" name="slug" value="{{ $data->slug }}"
                                        required="required">
                                </div>
                            </div>
                            @error('slug')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label>Carrier Description</label>
                            <textarea class="form-control" id="description" name="description">{!!$data->description!!}</textarea>
                            @error('description')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>

@endpush