@extends('backend.layouts.app')

@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>SMS Api</h4>

        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <form action="{{ route('sms.submit')}}" method="POST" enctype="multipart/form-data">
            @csrf 
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-12 col-sm-12 col-12">
                        Status : {{ $data->sms_status }} 
                        @if($data->sms_status == 'on' ) <a class="btn-sm btn-warning text-white" style="float: right;" href="{{ route('sms.status')}}">Turn Off</a> @else <a class="btn-sm btn-primary" style="float: right;"  href="{{ route('sms.status')}}">Turn On</a> @endif
                    </div><br><br>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Bulksmsbd.com API Key</label>
                            <input type="text" name="sms_api_key" value="{{ $data->sms_api_key }}" >
                            @error('sms_api_key')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Bulksmsbd.com sender ID</label>
                            <input type="text" name="sms_sender_id" value="{{ $data->sms_sender_id }}" >
                            @error('sms_sender_id')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
    @if($data->sms_api_key != null && $data->sms_sender_id !=null)
    <div class="card">
        <div class="card-body">
            <form action="{{ route('sms.test')}}" method="POST" enctype="multipart/form-data">
            @csrf 
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-12 col-sm-12 col-12">
                        Test your sms API
                    </div><br><br>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Your Phone Number</label>
                            <input type="number" name="phone" value="{{ $data->phone }}" >
                            @error('phone')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            SMS Balance: <span style="background: green; padding: 10px 20px; border-radius: 10px; color: white;">{{ $amount }}</span>
        </div>
    </div>
    @endif
</div>
@endsection
@push('styles')

@endpush


@push('scripts')

<script>
$(document).ready(function() {

$('.datanews').DataTable({
    "bFilter": true,
    "sDom": 'fBtlpi',
    'pagingType': 'numbers',
    "ordering": true,
    "select": true,
    
    "language": {
        search: ' ',
        sLengthMenu: '_MENU_',
        searchPlaceholder: "Search...",
        info: "_START_ - _END_ of _TOTAL_ items",
    },
    "buttons": [
        {
            extend: 'csv',
            title: 'Product Inventory',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            }
        },
        {
            extend: 'excel',
            title: 'Product List',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            }
        },
        {
            extend: 'pdfHtml5',
            title: 'Product Inventory',
            exportOptions: {
                columns: "thead th:not(.noExport)"
            },
        },
    ],
    initComplete: (settings, json) => {
        $('.dataTables_filter').appendTo('#tableSearch');
        $('.dataTables_filter').appendTo('.search-input');
    },
   

    
});
} );
</script>
@endpush