// public/js/delivery_status.js

$(document).ready(function() {
    // Function to fetch delivery status for a specific order asynchronously
    function fetchDeliveryStatus(orderId) {
        $.ajax({
            url: '/status_by_invoice/' + orderId,
            type: 'GET',
            success: function(response) {
                // Update the delivery status on the page
                $('#delivery-status-' + orderId).text(response.delivery_status);
            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error('Error fetching delivery status:', error);
                $('#delivery-status-' + orderId).text('Error'); // Display error message
            }
        });
    }

    // Fetch delivery statuses for all orders on page load
    $('.order-row').each(function() {
        var orderId = $(this).data('order-id');
        fetchDeliveryStatus(orderId);
    });
});
