<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductColorVariation extends Model
{
    protected $fillable = [
        'product_id',
        'color_id',
        'stock',
        'price',
        'image',
    ];

    // Define relationships if needed
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function color()
    {
        return $this->belongsTo(Color::class);
    }
}