<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable=['bank_trxid','assign_user_id','created_at','user_id','store_id','pathao_city','pathao_state','pathao_area_id','weight','redx_area_id','redx_area','qty','trxid','order_number', 'payment','sub_total', 'shipping_cost', 'discount','total_amount', 'payment_method', 'payment_status', 'status','color_n', 'first_name', 'phone', 'address', 'note','products_id','collectables','city','p_cost','ip_address','state','fbwaorder'];

    public function cart_info(){
        return $this->hasMany('App\Models\Cart','order_id','id');
    }
    public static function getAllOrder($id){
        return Order::with('cart_info')->find($id);
    }
    public static function countActiveOrder(){
        $data=Order::count();
        if($data){
            return $data;
        }
        return 0;
    }
    public function cart(){
        return $this->hasMany(Cart::class);
    }

    public function shipping(){
        return $this->belongsTo(Shipping::class,'shipping_id');
    }
    
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function orderDetails()
    {
        return $this->hasMany(OrderDetail::class);
    }
    public function products()
    {
        return $this->hasManyThrough(Product::class, OrderDetail::class);
    }
    

}
