<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SmsTemplate;
use App\Models\StatusControl;

use Illuminate\Support\Str;

class SmsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = SmsTemplate::get();
        return view('backend.sms_template.index')->with('products', $products);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $products = StatusControl::get();
        $data = SmsTemplate::get();
        return view('backend.sms_template.create', compact('products', 'data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request, [
            'sms_for' => 'string|required',
            'message' => 'string|required',
        ]);

        $data = $request->all();

        $status = SmsTemplate::create($data);
        if ($status) {

            request()->session()->flash('success', 'Template Successfully added');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('sms_template.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = SmsTemplate::findOrFail($id);
        return view('backend.sms_template.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Category = SmsTemplate::findOrFail($id);

        $this->validate($request, [
            'sms_for' => 'string|required',
            'message' => 'string|required',
        ]);

        $data = $request->all();
        $status = $Category->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Template Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('sms_template.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = SmsTemplate::findOrFail($id);

        $status = $category->delete();

        if ($status) {
            request()->session()->flash('success', 'Template successfully deleted');
        } else {
            request()->session()->flash('error', 'Error while deleting Template');
        }
        return redirect()->route('sms_template.index');
    }
}
