<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Shipping;
use App\Models\State;

use Illuminate\Support\Str;

class ShippingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = Shipping::get();
        return view('backend.shipping.index')->with('products', $products);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $state = State::get();
        return view('backend.shipping.create', compact('state'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request, [
            'type' => 'string|required',
            'price' => 'string|required',
            'state_id' => ' ',
        ]);

        $data = $request->all();

        $status = Shipping::create($data);
        if ($status) {

            request()->session()->flash('success', 'Shipping Successfully added');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('shipping.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Shipping::findOrFail($id);
        $state = State::get();
        return view('backend.shipping.edit', compact('data', 'state'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Category = Shipping::findOrFail($id);
        $this->validate($request, [
            'type' => 'string|required',
            'price' => 'string|required',
            'state_id' => 'required',
        ]);
        $data = $request->all();
        $status = $Category->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Shipping Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('shipping.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = Shipping::findOrFail($id);

        $status = $category->delete();

        if ($status) {
            request()->session()->flash('success', 'Shipping successfully deleted');
        } else {
            request()->session()->flash('error', 'Error while deleting Shipping');
        }
        return redirect()->route('shipping.index');
    }
}
