<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Landing;

use Illuminate\Support\Str;

class LandingsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $landings = Landing::where('template', 'no')->get();
        return view('backend.landings.index')->with('landings', $landings);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function template()
    {
        $templates = Landing::where('template', 'yes')->get();
        return view('backend.landings.template', compact('templates'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function createNew($slug)
    {
        if ($slug) {
            $landing = Landing::where('slug', $slug)->firstOrFail();
            $products = Product::get();
            return view('backend.landings.create_new', compact('landing', 'products'));
        } else {
            request()->session()->flash('error', 'Sorry! The action is not permitted');
            return redirect()->route('landings.index');
        }
    }

    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request, [
            'title' => 'string|required',
            'slug' => 'unique:landings,slug',
            'title2' => 'required',
            'video_url' => '',
            'des1' => ' ',
            'product_name' => ' ',
            'des2' => '',
            'feature' => ' ',
            'description' => ' ',
            'old_price' => 'required',
            'new_price' => 'required',
            'phone' => '',
            'pay_text' => '',
            'product_id' => ''


        ]);

        $data = $request->all();
        // Generate a random string of length 5
        $randomString = Str::random(5);

        // Convert the random string to uppercase
        $uppercaseRandomString = strtoupper($randomString);

        // Concatenate the title from the request with a hyphen and the uppercase random string
        $slugSuffix = "-" . $uppercaseRandomString;

        // Generate a slug from the concatenated string
        $titleSlug = Str::slug($request->title);

        // Combine the title slug with the slug suffix
        $combinedSlug = $titleSlug . $slugSuffix;

        // Assign the combined slug to the data array
        $data["slug"] = $combinedSlug;

        $product_ids = $request->input('product_id');

        if ($request->hasFile('video')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('video')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('video')->getClientOriginalExtension();
            // Filename to store
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            // Upload image
            $path = $request->file('video')->storeAs('public/video', $fileNameToStore);
            $data['video'] = $fileNameToStore;
        }



        //dd($data);

        $status = Landing::create($data);
        if ($status) {

            request()->session()->flash('success', 'Landing Page Successfully added');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('landings.index');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Landing::findOrFail($id);
        $products = Product::get();
        return view('backend.landings.edit', compact('data', 'products'));
    }





    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Category = Landing::findOrFail($id);
        $this->validate($request, [
            'title' => 'string|required',
            'slug' => 'string',
            'title2' => 'required',
            'video_url' => '',
            'des1' => 'required',
            'product_name' => 'required',
            'des2' => '',
            'feature' => 'required',
            'description' => 'string|required',
            'old_price' => '',
            'new_price' => '',
            'phone' => '',
            'pay_text' => '',
            'product_id' => ''
        ]);
        $data = $request->all();
        $status = $Category->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Landing Page Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('landings.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        request()->session()->flash('error', 'Sorry! the action is not permitted');
        return redirect()->route('landings.index');
    }
}
