<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\IPBlock;

class IPBlockController extends Controller
{
    public function index()
    {
        $seen = IPBlock::all();
        return view('backend.ipblock.index', compact('seen'));
    }

    public function create()
    {
        return view('backend.ipblock.add');
    }

    public function store(Request $request)
    {


        $this->validate($request, [
            'ip_address' => 'required',
            'note' => '',
        ]);

        $data = $request->all();

        $status = IPBlock::create($data);
        if ($status) {

            request()->session()->flash('success', 'Ip Block Successfully added');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }

        return redirect()->route('ipblock.index');
    }

    public function destroy($id)
    {
        $de = IPBlock::findOrFail($id);
        $de->delete();

        request()->session()->flash('success', 'Deleted Successfully');
        return redirect()->back();
    }
}
