<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Expense;
use Carbon;

class ExpenseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = [];
        $created_at =  Carbon\Carbon::today();
        $created_at = $created_at->format('d-m-Y');
        $fromDate = $created_at;
        $todate = $created_at;

        $data = Expense::orderBy('created_at', 'DESC')->get();
        //dd($data);

        return view('backend.expenses.index', compact('data', 'fromDate', 'todate'));
    }
    public function expensesdate(Request $request)
    {
        $data = [];
        $fromDate = $request->fromDate;
        $todate = $request->todate;

        $data = Expense::whereBetween('created_at', [Carbon\Carbon::parse($fromDate)->startOfDay(), Carbon\Carbon::parse($todate)->endOfDay()])->orderBy('created_at', 'DESC')->get();
        //dd($data);

        return view('backend.expenses.index', compact('data', 'fromDate', 'todate'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.expenses.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request, [
            'title' => 'string|required',
            'amount' => 'required',
        ]);

        $data = $request->all();

        $status = Expense::create($data);
        if ($status) {

            request()->session()->flash('success', 'Expense Successfully added');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('expenses.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Expense::findOrFail($id);
        return view('backend.expenses.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Category = Expense::findOrFail($id);
        $this->validate($request, [
            'title' => 'string|required',
            'amount' => 'required',
        ]);
        $data = $request->all();
        $status = $Category->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Expense Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('expenses.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = Expense::findOrFail($id);

        $status = $category->delete();

        if ($status) {
            request()->session()->flash('success', 'Expense successfully deleted');
        } else {
            request()->session()->flash('error', 'Error while deleting Expense');
        }
        return redirect()->route('expenses.index');
    }
}
