<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;

use Illuminate\Support\Str;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $categorys = Category::get();
        return view('backend.category.index')->with('categorys', $categorys);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $category = Category::where('is_parent', 1)->get();
        $issub = Category::get();
        return view('backend.category.create')->with('categories', $category)->with('issubs', $issub);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request, [
            'title' => 'string|required',
            'slug' => 'unique:categories,slug',
            'is_parent' => 'required',
            'parent_id' => 'nullable',

            'status' => "required",
        ]);

        $data = $request->all();
        $data['slug'] = Str::slug($request->title, '-');

        if ($request->is_parent == 1) {
            $data['parent_id'] = null;
        }

        $status = Category::create($data);
        if ($status) {

            request()->session()->flash('success', 'Category Successfully added');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('category.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Category::findOrFail($id);
        $category = Category::where('is_parent', 1)->get();
        return view('backend.category.edit', compact('data', 'category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Category = Category::findOrFail($id);
        $this->validate($request, [
            'title' => 'string|required',
            'slug' => 'string|required',
            'is_parent' => 'required',
            'parent_id' => 'nullable',
            'status' => "required",
        ]);

        $data = $request->all();
        if ($request->is_parent == 1) {
            $data['parent_id'] = null;
        }


        $status = $Category->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Category Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('category.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = Category::findOrFail($id);

        if ($category->is_parent == 1) {
            $sub = Category::where('parent_id', $category->id)->get();
            foreach ($sub as $key => $value) {
                $finsub = Category::findOrFail($value->id);
                $finsub->delete();
            }
        }

        $status = $category->delete();

        if ($status) {
            request()->session()->flash('success', 'Category successfully deleted');
        } else {
            request()->session()->flash('error', 'Error while deleting Category');
        }
        return redirect()->route('category.index');
    }
}
