<?php

namespace App\Http\Controllers;

use Auth;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\OrderDetail;
use App\Models\Order;
use App\Models\Coupon;
use App\Models\Shipping;
use App\Models\State;
use App\Models\Api;
use App\Models\User;
use App\Models\SmsTemplate;
use App\Models\Setting;
use App\Models\Tracking;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Session;
use URL;
use Cart;
use Log;
use App\Library\SslCommerz\SslCommerzNotification;


class CartController extends Controller
{
    private $base_url;

    public function __construct()
    {
        // Sandbox
        // $this->base_url = 'https://tokenized.sandbox.bka.sh/v1.2.0-beta';
        // Live
        $this->base_url = 'https://tokenized.pay.bka.sh/v1.2.0-beta';
    }

    public function authHeaders()
    {
        return array(
            'Content-Type:application/json',
            'Authorization:' . $this->grant(),
            'X-APP-Key:' . env('BKASH_CHECKOUT_URL_APP_KEY')
        );
    }

    public function curlWithBody($url, $header, $method, $body_data_json)
    {
        $curl = curl_init($this->base_url . $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $body_data_json);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    public function grant()
    {
        $header = array(
            'Content-Type:application/json',
            'username:' . env('BKASH_CHECKOUT_URL_USER_NAME'),
            'password:' . env('BKASH_CHECKOUT_URL_PASSWORD')
        );
        $header_data_json = json_encode($header);

        $body_data = array('app_key' => env('BKASH_CHECKOUT_URL_APP_KEY'), 'app_secret' => env('BKASH_CHECKOUT_URL_APP_SECRET'));
        $body_data_json = json_encode($body_data);

        $response = $this->curlWithBody('/tokenized/checkout/token/grant', $header, 'POST', $body_data_json);

        $token = json_decode($response)->id_token;

        return $token;
    }


    public function getcity(Request $request)
    {
        $data = Shipping::where('state_id', $request->state)->get();
        return $data;
    }
    public function cartAdd(Request $request)
    {
        \Cart::session($request->token)->update($request->id, [
            'quantity' => 1
        ]);

        $cartCollection = \Cart::getTotal();
        return $cartCollection;
    }
    public function cartRemove(Request $request)
    {
        \Cart::session($request->token)->update($request->id, [
            'quantity' => -1
        ]);

        $cartCollection = \Cart::getTotal();
        return $cartCollection;
    }
    public function cartDelete(Request $request)
    {
        \Cart::session($request->token)->remove($request->id);
        $cartCollection = \Cart::getTotal();
        $cartCount = \Cart::getContent()->count();
        return compact('cartCount', 'cartCollection');
    }
    public function remove(Request $request)
    {
        session()->forget('coupon');
        return redirect()->back()->with('success', 'Coupon removed successfully.');
    }

    public function addToCart(Request $request)
    {

        // Validate the incoming request data
        $request->validate([
            'id' => 'required',
            'quantity' => 'required|numeric|min:1',
        ]);

        try {
            // Retrieve product details based on ID
            $product = Product::findOrFail($request->id);

            // Determine the price based on whether sprice or liquidprice is set
            $price = isset($request->prices) ? $request->prices : $request->sprice ?? $product->offer_price;

            // Generate a random ID for the cart item
            $randomId = rand(1, 5000);

            // Add the product to the cart
            Cart::session($request->token)->add([
                'id' => $randomId,
                'name' => $product->title,
                'price' => $price,
                'quantity' => $request->quantity,
                'attributes' => [
                    'color' => $request->color,
                    'size' => $request->size,
                    'liquid' => $request->liquid,
                    'sprice' => $request->sprice,
                    'prices' => $request->prices,
                ],
                'associatedModel' => $product,
            ]);

            // Return the updated cart count
            $cartCount = Cart::getContent()->count();
            return $cartCount;
        } catch (\Exception $e) {
            // Log the error for debugging
            Log::error($e);
            // Return an error response
            return response()->json(['error' => 'An error occurred while adding the product to the cart.'], 500);
        }
    }

    public function cartview()
    {
        return view('layouts.cart');
    }
    public function orderSubmit(Request $request)
    {
        //return $request->all();
        $this->validate($request, [
            'customerName' => 'string|required',
            'customerAddress' => 'string|required',
            'customerPhone' => ['required', 'numeric', 'regex:/^01/', 'digits:11'],
        ], [
            'customerPhone.regex' => 'মোবাইল নম্বরটি ১১ টি অক্ষরের হতে হবে।',
            'customerShipping' => 'required',
            'payment_method' => 'required',
            'ip_address' => 'required',
        ]);


        $city = Shipping::where("id", $request->city)->first();
        $items = \Cart::session($request->_token)->getContent();
        $productCount = count($items);

        // Flag to track if any product has free shipping
        $hasFreeShipping = false;

        // Preload products to avoid repeated database queries
        $productIds = $items->pluck('associatedModel.id')->toArray();
        $products = Product::whereIn('id', $productIds)->get();

        foreach ($items as $row) {
            // Find the corresponding product in preloaded products
            $product = $products->where('id', $row->associatedModel->id)->first();

            // Check if the product has free shipping enabled
            if ($product && $product->freeshipping == 'active') {
                $hasFreeShipping = true;
                break; // Exit the loop as soon as we find a product with freeshipping
            }
        }

        // Check shipping method condition
        if ($hasFreeShipping && $request->customerShipping == 0) {
            // Flash an error message and redirect back if conditions are not met
            request()->session()->flash("error", "Please select Shipping Method");
            return back();
        }


        //dd( $items);

        if (count($items) > 0) {

            $order = new Order();
            $order_data = $request->all();
            //dd($order_data);

            if (session()->has('coupon')) {

                $coupon = Coupon::where('code', session()->get('coupon')['value'])->first();
                if (isset($coupon)) {
                    $order_data['discount'] = session()->get('coupon')['value'];
                } else {
                    $order_data['discount'] = 0;
                }
            } else {
                $order_data['discount'] = 0;
            }

            $order_data['order_number'] = "ON" . rand(111111, 999999);
            $order_data['shipping_cost'] = $request->customerShipping;
            $order_data['sub_total'] = \Cart::getTotal();
            $order_data['total_amount'] = \Cart::getTotal() + $request->customerShipping;
            $order_data['status'] = "New Order";

            $order_data['payment_status'] = 'Unpaid';
            $order_data['first_name'] = $request->customerName;
            $order_data['phone'] = $request->customerPhone;
            $order_data['address'] = $request->customerAddress;
            $order_data['note'] = $request->customerNote;
            $order_data['ip_address'] = $request->ip();



            if ($request->payment_method == "cod") {
                $order_data['trxid'] = $request->trxid;
            } else if ($request->payment_method == 'bank') {

                $order_data['payment_method'] = 'bank';
            } else if ($request->payment_method == 'bkashpar') {

                $order_data['payment_method'] = 'bkashpar';
            } else {

                $order_data['payment_method'] = 'bkash';
            }

            $user = User::where('role', 'staff')->inRandomOrder()->first();
            if ($user) {
                $order_data['assign_user_id'] = $user->id;
            } else {
                $order_data['assign_user_id'] = 1;
            }

            $order->fill($order_data);
            $status = $order->save();
            if (!Auth::user()) {
                $phone = User::where("phone", $order->phone)->first();
                if (isset($phone)) {
                    $phone->save();
                    Auth::login($phone);
                } else {
                    $newuser = User::create([
                        "name" => $order->first_name,
                        "phone" => $order->phone,
                        "verified" => 1,
                        "current_address" => $request->customerAddress,
                        "password" => Hash::make("12345678"),
                    ]);
                    Auth::login($newuser);
                }
            }
            // Assuming $order is already defined somewhere in your code
            $order = Order::findOrFail($order->id); // Fetch the specific Order using findOrFail

            $data = ['user_id' => auth()->user()->id]; // Prepare data to update

            $order->update($data); // Update the Order record with the new user_id

            foreach ($items as $row) {
                $product = Product::where('id', $row->associatedModel->id)->first();
                $cart = new OrderDetail;
                $cart->product_id = $product->id;
                $cart->user_id = auth()->user()->id;
                $cart->order_id = $order->id;
                $cart->cost = $product->cost;
                $cart->price = $product->offer_price;
                $cart->quantity = $row->quantity;
                $cart->size_id = $row->attributes->size;
                $cart->liquid_id = $row->attributes->liquid;
                $cart->size = $request->sizeName;
                $cart->color = $row->attributes->color;
                $cart->amount = $product->offer_price * $row->quantity;
                $cart->save();
            }

            if ($order) {
                request()->session()->flash('success', 'Successfully placed in order');
                $clear = \Cart::session($request->_token)->clear();
                session()->forget('coupon');
                $smsapi = Api::where('id', 1)->first();
                if ($smsapi->sms_status == 'on') {
                    $settings = Setting::where('id', 1)->first();
                    $smstemp = SmsTemplate::where('sms_for', 'New Order')->first();
                    if (isset($smstemp)) {
                        if ($smstemp->status == 'on') {
                            $message = $smstemp->message;
                            $orderprefix = $settings->order_prefix;
                            $orderid = $settings->order_prefix . $order->id;
                            $amount = $order->total_amount;
                            $sub_total = $order->sub_total;
                            $discount = $order->discount;
                            $collectables = $order->payment - $order->total_amount;
                            $shippingcost  = $order->shipping_cost;
                            $first_name  = $order->first_name;
                            $phone  = $order->phone;
                            $address  = $order->address;

                            $message = str_replace('{id}', $orderid, $message);
                            $message = str_replace('{amount}', $amount, $message);
                            $message = str_replace('{sub_total}', $sub_total, $message);
                            $message = str_replace('{discount}', $discount, $message);
                            $message = str_replace('{shipping_cost}', $shippingcost, $message);
                            $message = str_replace('{name}', $first_name, $message);
                            $message = str_replace('{phone}', $phone, $message);
                            $message = str_replace('{address}', $address, $message);
                            $message = str_replace('{collectables}', $collectables, $message);


                            $phonenumber = $order->phone;
                            $message = urlencode($message);
                            $phoneNumber = "88" . $phonenumber; // The phone number to send the message to
                            //dd($phoneNumber);
                            $senderId = $smsapi->sms_sender_id; // Your approved Sender ID
                            $apiKey = $smsapi->sms_api_key; // Your API key

                            // Build the URL
                            $url = "http://bulksmsbd.net/api/smsapi?api_key=" . $apiKey . "&type=text&number=" . $phoneNumber . "&senderid=" . $senderId . "&message=" . $message;

                            // Initialize cURL
                            $ch = curl_init();

                            // Set cURL options
                            curl_setopt($ch, CURLOPT_URL, $url);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                            // Execute the request
                            $response = curl_exec($ch);

                            // Close the cURL session
                            curl_close($ch);
                        }
                    }
                }
                if (!Auth::user()) {
                    $phone = User::where('phone', $order->phone)->first();
                    if (isset($phone)) {
                        if ($smsapi->sms_status == 'on') {
                            $phone->verified = 0;
                            $randomNumber = random_int(1000, 9999);
                            $phone->otp = $randomNumber;
                            $otp = $randomNumber;

                            $phonenumber = $order->phone;
                            $message = 'Your OTP:' . $otp . '';
                            $message = urlencode($message);
                            $phoneNumber = "88" . $phonenumber; // The phone number to send the message to
                            //dd($phoneNumber);
                            $senderId = $smsapi->sms_sender_id; // Your approved Sender ID
                            $apiKey = $smsapi->sms_api_key; // Your API key

                            // Build the URL
                            $url = "http://bulksmsbd.net/api/smsapi?api_key=" . $apiKey . "&type=text&number=" . $phoneNumber . "&senderid=" . $senderId . "&message=" . $message;

                            // Initialize cURL
                            $ch = curl_init();

                            // Set cURL options
                            curl_setopt($ch, CURLOPT_URL, $url);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                            // Execute the request
                            $response = curl_exec($ch);

                            // Close the cURL session
                            curl_close($ch);

                            $phone->save();
                            Auth::login($phone);
                            if ($order->payment_method == 'bkash') {
                                $amount = $order->total_amount;
                                $settings = Setting::where('id', 1)->first();
                                $header = $this->authHeaders();

                                $website_url = URL::to("/");

                                $body_data = array(
                                    'mode' => '0011',
                                    'payerReference' => ' ',
                                    'callbackURL' => $website_url . '/order-successfully-placed/' . $order->id,
                                    'amount' => $amount ? $amount : 10,
                                    'currency' => 'BDT',
                                    'intent' => 'sale',
                                    'merchantInvoiceNumber' => $settings->order_prefix . $order->id // you can pass here OrderID 
                                );
                                $body_data_json = json_encode($body_data);

                                $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

                                return redirect((json_decode($response)->bkashURL));
                            } elseif ($order->payment_method == 'bank') {
                                $post_data = array();
                                $post_data['store_id'] = env('SSLCZ_STORE_ID');
                                $post_data['store_passwd'] = env('SSLCZ_STORE_PASSWORD');
                                $post_data['total_amount'] = $order->total_amount;
                                $post_data['currency'] = "BDT";
                                $post_data['tran_id'] = uniqid();

                                Order::where('id', $order->id)->update(['bank_trxid' => $post_data['tran_id']]);


                                $post_data['emi_option'] = "0";


                                # CUSTOMER INFORMATION
                                $post_data['cus_name'] = $order->first_name;
                                $post_data['cus_email'] = 'none';
                                $post_data['cus_add1'] = $order->address;
                                $post_data['cus_add2'] = $order->state;
                                $post_data['cus_city'] = $order->city;
                                $post_data['cus_postcode'] = '1216';
                                $post_data['cus_country'] = "Bangladesh";
                                $post_data['cus_phone'] = $order->phone;

                                # SHIPMENT INFORMATION
                                $post_data['shipping_method'] = "NO";
                                $getcartquantity = OrderDetail::where('order_id', $order->id)
                                    ->sum('quantity');
                                $post_data['num_of_item'] = $getcartquantity;



                                # OPTIONAL PARAMETERS
                                $post_data['value_a'] = $order->id;

                                $getcart = OrderDetail::where('order_id', $order->id)
                                    ->get();

                                $product_names = '';
                                foreach ($getcart as $item) {
                                    $product = Product::find($item->product_id);
                                    $product_names .= $product->title . ', ';
                                }

                                // Remove the last comma and space from the string
                                $product_names = rtrim($product_names, ', ');


                                $post_data['product_name'] = $product_names;
                                $post_data['product_category'] = "Goods";
                                $post_data['product_profile'] = 'physical-goods';

                                $post_data['product_amount'] = $order->sub_total;
                                $post_data['vat'] = "0";
                                $post_data['discount_amount'] = $order->discount ?? 0;
                                $post_data['convenience_fee'] = "0";


                                $sslc = new SslCommerzNotification();
                                # initiate(Transaction Data , false: Redirect to SSLCOMMERZ gateway/ true: Show all the Payement gateway here )
                                $payment_options = $sslc->makePayment($post_data, 'hosted');

                                if (!is_array($payment_options)) {
                                    print_r($payment_options);
                                    $payment_options = array();
                                }
                            } else {
                                return redirect()->route('otp')->with('order_id', $order->id);
                            }
                        } else {
                            if ($order->payment_method == 'bkash') {
                                $amount = $order->total_amount;
                                $settings = Setting::where('id', 1)->first();
                                $header = $this->authHeaders();

                                $website_url = URL::to("/");

                                $body_data = array(
                                    'mode' => '0011',
                                    'payerReference' => ' ',
                                    'callbackURL' => $website_url . '/order-successfully-placed/' . $order->id,
                                    'amount' => $amount ? $amount : 10,
                                    'currency' => 'BDT',
                                    'intent' => 'sale',
                                    'merchantInvoiceNumber' => $settings->order_prefix . $order->id // you can pass here OrderID 
                                );
                                $body_data_json = json_encode($body_data);

                                $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

                                return redirect((json_decode($response)->bkashURL));
                            } elseif ($order->payment_method == 'bkashpar') {
                                foreach ($items as $row) {
                                    $productpar = Product::where('id', $row->associatedModel->id)->first();
                                    $parl = $productpar->sum('par_price');
                                    //$paramm = $product->par_price;
                                }
                                //$amount = $order->total_amount;
                                $settings = Setting::where('id', 1)->first();
                                $header = $this->authHeaders();

                                $website_url = URL::to("/");

                                $body_data = array(
                                    'mode' => '0011',
                                    'payerReference' => ' ',
                                    'callbackURL' => $website_url . '/order-successfully-placed/' . $order->id,
                                    'amount' => $parl ? $parl : 10,
                                    'currency' => 'BDT',
                                    'intent' => 'sale',
                                    'merchantInvoiceNumber' => $settings->order_prefix . $order->id // you can pass here OrderID 
                                );
                                $body_data_json = json_encode($body_data);

                                $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

                                return redirect((json_decode($response)->bkashURL));
                            } elseif ($order->payment_method == 'bank') {
                                $post_data = array();
                                $post_data['store_id'] = env('SSLCZ_STORE_ID');
                                $post_data['store_passwd'] = env('SSLCZ_STORE_PASSWORD');
                                $post_data['total_amount'] = $order->total_amount;
                                $post_data['currency'] = "BDT";
                                $post_data['tran_id'] = uniqid();

                                Order::where('id', $order->id)->update(['bank_trxid' => $post_data['tran_id']]);


                                $post_data['emi_option'] = "0";


                                # CUSTOMER INFORMATION
                                $post_data['cus_name'] = $order->first_name;
                                $post_data['cus_email'] = 'none';
                                $post_data['cus_add1'] = $order->address;
                                $post_data['cus_add2'] = $order->state;
                                $post_data['cus_city'] = $order->city;
                                $post_data['cus_postcode'] = '1216';
                                $post_data['cus_country'] = "Bangladesh";
                                $post_data['cus_phone'] = $order->phone;

                                # SHIPMENT INFORMATION
                                $post_data['shipping_method'] = "NO";
                                $getcartquantity = OrderDetail::where('order_id', $order->id)
                                    ->sum('quantity');
                                $post_data['num_of_item'] = $getcartquantity;



                                # OPTIONAL PARAMETERS
                                $post_data['value_a'] = $order->id;

                                $getcart = OrderDetail::where('order_id', $order->id)
                                    ->get();

                                $product_names = '';
                                foreach ($getcart as $item) {
                                    $product = Product::find($item->product_id);
                                    $product_names .= $product->title . ', ';
                                }

                                // Remove the last comma and space from the string
                                $product_names = rtrim($product_names, ', ');


                                $post_data['product_name'] = $product_names;
                                $post_data['product_category'] = "Goods";
                                $post_data['product_profile'] = 'physical-goods';

                                $post_data['product_amount'] = $order->sub_total;
                                $post_data['vat'] = "0";
                                $post_data['discount_amount'] = $order->discount ?? 0;
                                $post_data['convenience_fee'] = "0";


                                $sslc = new SslCommerzNotification();
                                # initiate(Transaction Data , false: Redirect to SSLCOMMERZ gateway/ true: Show all the Payement gateway here )
                                $payment_options = $sslc->makePayment($post_data, 'hosted');

                                if (!is_array($payment_options)) {
                                    print_r($payment_options);
                                    $payment_options = array();
                                }
                            } else {
                                return redirect()->route('order.received', $order->id);
                            }
                        }
                    } else {
                        if ($smsapi->sms_status == 'on') {
                            $randomNumber = random_int(1000, 9999);
                            $otp = $randomNumber;

                            $message = 'Your OTP:' . $otp . '';
                            $message = urlencode($message);
                            $phonenumber = $order->phone;
                            $phoneNumber = "88" . $phonenumber; // The phone number to send the message to
                            //dd($phoneNumber);
                            $senderId = $smsapi->sms_sender_id; // Your approved Sender ID
                            $apiKey = $smsapi->sms_api_key; // Your API key

                            // Build the URL
                            $url = "http://bulksmsbd.net/api/smsapi?api_key=" . $apiKey . "&type=text&number=" . $phoneNumber . "&senderid=" . $senderId . "&message=" . $message;

                            // Initialize cURL
                            $ch = curl_init();

                            // Set cURL options
                            curl_setopt($ch, CURLOPT_URL, $url);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                            // Execute the request
                            $response = curl_exec($ch);

                            // Close the cURL session
                            curl_close($ch);

                            $newuser = User::create([
                                'name' => $order->first_name,
                                'phone' => $order->phone,
                                'otp' => $otp,
                                'password' => Hash::make('12345678'),
                            ]);
                            Auth::login($newuser);
                            if ($order->payment_method == 'bkash') {
                                $amount = $order->total_amount;
                                $settings = Setting::where('id', 1)->first();
                                $header = $this->authHeaders();

                                $website_url = URL::to("/");

                                $body_data = array(
                                    'mode' => '0011',
                                    'payerReference' => ' ',
                                    'callbackURL' => $website_url . '/order-successfully-placed/' . $order->id,
                                    'amount' => $amount ? $amount : 10,
                                    'currency' => 'BDT',
                                    'intent' => 'sale',
                                    'merchantInvoiceNumber' => $settings->order_prefix . $order->id // you can pass here OrderID 
                                );
                                $body_data_json = json_encode($body_data);

                                $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

                                return redirect((json_decode($response)->bkashURL));
                            } elseif ($order->payment_method == 'bkashpar') {
                                foreach ($items as $row) {
                                    $product = Product::where('id', $row->associatedModel->id)->first();
                                    $paramm = $product->par_price;
                                }
                                // $amount = $order->total_amount;
                                $settings = Setting::where('id', 1)->first();
                                $header = $this->authHeaders();

                                $website_url = URL::to("/");

                                $body_data = array(
                                    'mode' => '0011',
                                    'payerReference' => ' ',
                                    'callbackURL' => $website_url . '/order-successfully-placed/' . $order->id,
                                    'amount' => $paramm ? $paramm : 10,
                                    'currency' => 'BDT',
                                    'intent' => 'sale',
                                    'merchantInvoiceNumber' => $settings->order_prefix . $order->id // you can pass here OrderID 
                                );
                                $body_data_json = json_encode($body_data);

                                $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

                                return redirect((json_decode($response)->bkashURL));
                            } else {
                                return redirect()->route('otp')->with('order_id', $order->id);
                            }
                        } else {
                            if ($order->payment_method == 'bkash') {
                                $amount = $order->total_amount;
                                $settings = Setting::where('id', 1)->first();
                                $header = $this->authHeaders();

                                $website_url = URL::to("/");

                                $body_data = array(
                                    'mode' => '0011',
                                    'payerReference' => ' ',
                                    'callbackURL' => $website_url . '/order-successfully-placed/' . $order->id,
                                    'amount' => $amount ? $amount : 10,
                                    'currency' => 'BDT',
                                    'intent' => 'sale',
                                    'merchantInvoiceNumber' => $settings->order_prefix . $order->id // you can pass here OrderID 
                                );
                                $body_data_json = json_encode($body_data);

                                $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

                                return redirect((json_decode($response)->bkashURL));
                            } elseif ($order->payment_method == 'bkashpar') {
                                foreach ($items as $row) {
                                    $product = Product::where('id', $row->associatedModel->id)->first();
                                    $paramm = $product->par_price;
                                }
                                //$amount = $order->total_amount;
                                $settings = Setting::where('id', 1)->first();
                                $header = $this->authHeaders();

                                $website_url = URL::to("/");

                                $body_data = array(
                                    'mode' => '0011',
                                    'payerReference' => ' ',
                                    'callbackURL' => $website_url . '/order-successfully-placed/' . $order->id,
                                    'amount' => $paramm ? $paramm : 10,
                                    'currency' => 'BDT',
                                    'intent' => 'sale',
                                    'merchantInvoiceNumber' => $settings->order_prefix . $order->id // you can pass here OrderID 
                                );
                                $body_data_json = json_encode($body_data);

                                $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

                                return redirect((json_decode($response)->bkashURL));
                            } elseif ($order->payment_method == 'bank') {
                                $post_data = array();
                                $post_data['store_id'] = env('SSLCZ_STORE_ID');
                                $post_data['store_passwd'] = env('SSLCZ_STORE_PASSWORD');
                                $post_data['total_amount'] = $order->total_amount;
                                $post_data['currency'] = "BDT";
                                $post_data['tran_id'] = uniqid();

                                Order::where('id', $order->id)->update(['bank_trxid' => $post_data['tran_id']]);


                                $post_data['emi_option'] = "0";


                                # CUSTOMER INFORMATION
                                $post_data['cus_name'] = $order->first_name;
                                $post_data['cus_email'] = 'none';
                                $post_data['cus_add1'] = $order->address;
                                $post_data['cus_add2'] = $order->state;
                                $post_data['cus_city'] = $order->city;
                                $post_data['cus_postcode'] = '1216';
                                $post_data['cus_country'] = "Bangladesh";
                                $post_data['cus_phone'] = $order->phone;

                                # SHIPMENT INFORMATION
                                $post_data['shipping_method'] = "NO";
                                $getcartquantity = OrderDetail::where('order_id', $order->id)
                                    ->sum('quantity');
                                $post_data['num_of_item'] = $getcartquantity;



                                # OPTIONAL PARAMETERS
                                $post_data['value_a'] = $order->id;

                                $getcart = OrderDetail::where('order_id', $order->id)
                                    ->get();

                                $product_names = '';
                                foreach ($getcart as $item) {
                                    $product = Product::find($item->product_id);
                                    $product_names .= $product->title . ', ';
                                }

                                // Remove the last comma and space from the string
                                $product_names = rtrim($product_names, ', ');


                                $post_data['product_name'] = $product_names;
                                $post_data['product_category'] = "Goods";
                                $post_data['product_profile'] = 'physical-goods';

                                $post_data['product_amount'] = $order->sub_total;
                                $post_data['vat'] = "0";
                                $post_data['discount_amount'] = $order->discount ?? 0;
                                $post_data['convenience_fee'] = "0";


                                $sslc = new SslCommerzNotification();
                                # initiate(Transaction Data , false: Redirect to SSLCOMMERZ gateway/ true: Show all the Payement gateway here )
                                $payment_options = $sslc->makePayment($post_data, 'hosted');

                                if (!is_array($payment_options)) {
                                    print_r($payment_options);
                                    $payment_options = array();
                                }
                            } else {
                                return redirect()->route('order.received', $order->id);
                            }
                        }
                    }
                } else {
                    if ($order->payment_method == 'bkash') {
                        $amount = $order->total_amount;
                        $settings = Setting::where('id', 1)->first();
                        $header = $this->authHeaders();

                        $website_url = URL::to("/");

                        $body_data = array(
                            'mode' => '0011',
                            'payerReference' => ' ',
                            'callbackURL' => $website_url . '/order-successfully-placed/' . $order->id,
                            'amount' => $amount ? $amount : 10,
                            'currency' => 'BDT',
                            'intent' => 'sale',
                            'merchantInvoiceNumber' => $settings->order_prefix . $order->id // you can pass here OrderID 
                        );
                        $body_data_json = json_encode($body_data);

                        $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

                        return redirect((json_decode($response)->bkashURL));
                    }
                    if ($order->payment_method == 'bkashpar') {
                        foreach ($items as $row) {
                            $product = Product::where('id', $row->associatedModel->id)->first();
                            $paramm = $product->par_price;
                        }
                        $settings = Setting::where('id', 1)->first();
                        $header = $this->authHeaders();

                        $website_url = URL::to("/");

                        $body_data = array(
                            'mode' => '0011',
                            'payerReference' => ' ',
                            'callbackURL' => $website_url . '/order-successfully-placed/' . $order->id,
                            'amount' => $paramm ? $paramm : 10,
                            'currency' => 'BDT',
                            'intent' => 'sale',
                            'merchantInvoiceNumber' => $settings->order_prefix . $order->id // you can pass here OrderID 
                        );
                        $body_data_json = json_encode($body_data);

                        $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

                        return redirect((json_decode($response)->bkashURL));
                    } elseif ($order->payment_method == 'bank') {
                        $post_data = array();
                        $post_data['store_id'] = env('SSLCZ_STORE_ID');
                        $post_data['store_passwd'] = env('SSLCZ_STORE_PASSWORD');
                        $post_data['total_amount'] = $order->total_amount;
                        $post_data['currency'] = "BDT";
                        $post_data['tran_id'] = uniqid();

                        Order::where('id', $order->id)->update(['bank_trxid' => $post_data['tran_id']]);


                        $post_data['emi_option'] = "0";


                        # CUSTOMER INFORMATION
                        $post_data['cus_name'] = $order->first_name;
                        $post_data['cus_email'] = 'none';
                        $post_data['cus_add1'] = $order->address;
                        $post_data['cus_add2'] = $order->state;
                        $post_data['cus_city'] = $order->city;
                        $post_data['cus_postcode'] = '1216';
                        $post_data['cus_country'] = "Bangladesh";
                        $post_data['cus_phone'] = $order->phone;

                        # SHIPMENT INFORMATION
                        $post_data['shipping_method'] = "NO";
                        $getcartquantity = OrderDetail::where('order_id', $order->id)
                            ->sum('quantity');
                        $post_data['num_of_item'] = $getcartquantity;



                        # OPTIONAL PARAMETERS
                        $post_data['value_a'] = $order->id;

                        $getcart = OrderDetail::where('order_id', $order->id)
                            ->get();

                        $product_names = '';
                        foreach ($getcart as $item) {
                            $product = Product::find($item->product_id);
                            $product_names .= $product->title . ', ';
                        }

                        // Remove the last comma and space from the string
                        $product_names = rtrim($product_names, ', ');


                        $post_data['product_name'] = $product_names;
                        $post_data['product_category'] = "Goods";
                        $post_data['product_profile'] = 'physical-goods';

                        $post_data['product_amount'] = $order->sub_total;
                        $post_data['vat'] = "0";
                        $post_data['discount_amount'] = $order->discount ?? 0;
                        $post_data['convenience_fee'] = "0";


                        $sslc = new SslCommerzNotification();
                        # initiate(Transaction Data , false: Redirect to SSLCOMMERZ gateway/ true: Show all the Payement gateway here )
                        $payment_options = $sslc->makePayment($post_data, 'hosted');

                        if (!is_array($payment_options)) {
                            print_r($payment_options);
                            $payment_options = array();
                        }
                    } else {
                        return redirect()->route('order.received', $order->id);
                    }
                }
            } else {
                request()->session()->flash('error', 'Something is wrong');
                return back();
            }
        } else {
            request()->session()->flash('error', 'No product found');
            return back();
        }
    }
    public function couponStore(Request $request)
    {
        $coupon = Coupon::where('code', $request->code)->first();
        if (isset($coupon)) {
            session()->put('coupon', [
                'code' => $coupon->code,
                'value' => $coupon->value,
            ]);
            request()->session()->flash('success', 'Successfully Submit');
            return redirect()->back();
        } else {
            request()->session()->flash('error', 'Invalid coupon code');
            return back();
        }
    }
}
