<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;
use App\Models\Carrier;
use App\Models\Setting;

use Illuminate\Support\Str;

class CarriersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products=Carrier::get();
        return view('backend.carriers.index')->with('products',$products);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.carriers.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request,[
            'title'=>'string|required',
            'description'=>'string|required',
            'slug'=>'string|unique:carriers',
        ]);

        $data=$request->all();
        
        $status=Carrier::create($data);
        if($status){

            request()->session()->flash('success','Carrier Successfully added');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('career.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data=Carrier::findOrFail($id);
        return view('backend.carriers.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Category=Carrier::findOrFail($id);
        $this->validate($request,[
            'title'=>'string|required',
            'description'=>'string|required',
            'slug'=>'string',
        ]);
        $data=$request->all();
        $status=$Category->fill($data)->save();
        if($status){
            request()->session()->flash('success','Carrier Successfully updated');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('career.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category=Carrier::findOrFail($id);

        $status=$category->delete();

        if($status){
            request()->session()->flash('success','Carrier successfully deleted');
        }
        else{
            request()->session()->flash('error','Error while deleting Carrier');
        }
        return redirect()->route('career.index');
    }
}
