<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Brand;

use Illuminate\Support\Str;

class BrandController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = Brand::get();
        return view('backend.brand.index')->with('products', $products);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $brand = Brand::where('is_parent', 1)->get();
        return view('backend.brand.create')->with('brands', $brand);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request, [
            'title' => 'string|required',
            'slug' => 'unique:brands,slug',
            'is_parent' => 'required',
            'parent_id' => 'nullable',
            'status' => "required",
        ]);

        $data = $request->all();
        $data['slug'] = Str::slug($request->title, '-');

        if ($request->is_parent == 1) {
            $data['parent_id'] = null;
        }

        $status = Brand::create($data);
        if ($status) {

            request()->session()->flash('success', 'Brand Successfully added');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('brand.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Brand::findOrFail($id);
        $brand = Brand::where('is_parent', 1)->get();
        return view('backend.brand.edit', compact('data', 'brand'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Brand = Brand::findOrFail($id);
        $this->validate($request, [
            'title' => 'string|required',
            'slug' => 'string|required',
            'is_parent' => 'required',
            'parent_id' => 'nullable',
            'status' => "required",
        ]);

        $data = $request->all();
        if ($request->is_parent == 1) {
            $data['parent_id'] = null;
        }


        $status = $Brand->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Brand Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('brand.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $brand = Brand::findOrFail($id);

        if ($brand->is_parent == 1) {
            $sub = Brand::where('parent_id', $brand->id)->get();
            foreach ($sub as $key => $value) {
                $finsub = Brand::findOrFail($value->id);
                $finsub->delete();
            }
        }

        $status = $brand->delete();

        if ($status) {
            request()->session()->flash('success', 'Brand successfully deleted');
        } else {
            request()->session()->flash('error', 'Error while deleting Brand');
        }
        return redirect()->route('brand.index');
    }
}
