<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Api;
use App\Models\Order;
use App\Models\Setting;
use App\Models\SteadFast;
use App\Models\Redx;
use App\Models\Pathao;
use Illuminate\Support\Facades\Http;
use Session;
use URL;
use Illuminate\Support\Str;

class ApiController extends Controller
{
    private $base_url;
    public function __construct()
    {
        // Sandbox
        //$this->base_url = "https://tokenized.sandbox.bka.sh/v1.2.0-beta";
        // Live
        $this->base_url = 'https://tokenized.pay.bka.sh/v1.2.0-beta';
    }
    public function authHeaders()
    {
        return [
            "Content-Type:application/json",
            "Authorization:" . $this->grant(),
            "X-APP-Key:" . env("BKASH_CHECKOUT_URL_APP_KEY"),
        ];
    }
    public function curlWithBody($url, $header, $method, $body_data_json)
    {
        $curl = curl_init($this->base_url . $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $body_data_json);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }
    public function grant()
    {
        $header = [
            "Content-Type:application/json",
            "username:" . env("BKASH_CHECKOUT_URL_USER_NAME"),
            "password:" . env("BKASH_CHECKOUT_URL_PASSWORD"),
        ];
        $header_data_json = json_encode($header);
        $body_data = [
            "app_key" => env("BKASH_CHECKOUT_URL_APP_KEY"),
            "app_secret" => env("BKASH_CHECKOUT_URL_APP_SECRET"),
        ];
        $body_data_json = json_encode($body_data);
        $response = $this->curlWithBody(
            "/tokenized/checkout/token/grant",
            $header,
            "POST",
            $body_data_json
        );
        $token = json_decode($response)->id_token;
        return $token;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function sms()
    {
        $data = Api::first();
        $amount = 0;
        if ($data->sms_api_key != null && $data->sms_sender_id != null) {
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL =>
                "http://bulksmsbd.net/api/getBalanceApi?api_key=" .
                    $data->sms_api_key .
                    "",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
            ]);
            $response = curl_exec($curl);
            //dd($response);
            $amount = $response;
            curl_close($curl);
        }
        return view("backend.api.sms")
            ->with("data", $data)
            ->with("amount", $amount);
    }
    public function bkash()
    {
        $data = Api::first();
        $message = "";
        return view("backend.api.bkash")
            ->with("data", $data)
            ->with("message", $message);
    }
    public function bkashnd()
    {
        $data = Api::first();
        $message = "";
        return view("backend.api.refund")
            ->with("data", $data)
            ->with("message", $message);
    }
    public function bkashsearch(Request $request)
    {
        $data = Api::first();
        $message = "";
        $header = $this->authHeaders();
        $body_data = [
            "trxID" => $request->trxID,
        ];
        $body_data_json = json_encode($body_data);
        $response = $this->curlWithBody(
            "/tokenized/checkout/general/searchTransaction",
            $header,
            "POST",
            $body_data_json
        );
        $res_array = json_decode($response, true);
        //dd($res_array);
        if (isset($res_array)) {
            request()
                ->session()
                ->flash("success", "Transaction found!");
            return view("backend.api.bkash")
                ->with("data", $data)
                ->with("message", $res_array);
        } else {
            request()
                ->session()
                ->flash("error", "Transaction not found!");
            return view("backend.api.bkash")
                ->with("data", $data)
                ->with("message", $message);
        }
    }
    public function bkashrefundstatus(Request $request)
    {
        $data = Api::first();
        $message = "";
        $header = $this->authHeaders();
        $body_data = [
            "trxID" => $request->trxID,
            "paymentID" => $request->paymentID,
        ];
        $body_data_json = json_encode($body_data);
        $response = $this->curlWithBody(
            "/tokenized/checkout/payment/refund",
            $header,
            "POST",
            $body_data_json
        );
        $res_array = json_decode($response, true);
        //dd($res_array);
        if (isset($res_array)) {
            request()
                ->session()
                ->flash("success", "Transaction found!");
            return view("backend.api.bkash")
                ->with("data", $data)
                ->with("message", $res_array);
        } else {
            request()
                ->session()
                ->flash("error", "Transaction not found!");
            return view("backend.api.bkash")
                ->with("data", $data)
                ->with("message", $message);
        }
    }
    public function bkashrefund(Request $request)
    {
        $data = Order::where("id", $request->id)->first();
        if (isset($data)) {
            $header = $this->authHeaders();
            $body_data = [
                "paymentID" => $request->paymentID,
                "amount" => $request->amount,
                "trxID" => $request->trxID,
                "sku" => $request->sku,
                "reason" => $request->reason,
            ];
            $body_data_json = json_encode($body_data);
            $response = $this->curlWithBody(
                "/tokenized/checkout/payment/refund",
                $header,
                "POST",
                $body_data_json
            );
            $res_array = json_decode($response, true);
            if (
                array_key_exists("statusCode", $res_array) &&
                $res_array["statusCode"] != "0000"
            ) {
                request()
                    ->session()
                    ->flash("error", $res_array["statusMessage"]);
                return view("confirm", compact("data"));
            } elseif (isset($res_array["refundTrxID"])) {
                request()
                    ->session()
                    ->flash("success", "Refund completed!!");
                $data->refundTrxID = $res_array["refundTrxID"];
                $data->payment = $data->payment - $request->amount;
                $data->save();
            } else {
                request()
                    ->session()
                    ->flash(
                        "error",
                        "Something is wrong!! Refund not completed!!"
                    );
            }
        } else {
            request()
                ->session()
                ->flash("error", "Order not found!");
        }
        return redirect()->back();
    }
    public function smsSubmit(Request $request)
    {
        $this->validate($request, [
            "sms_api_key" => "required",
            "sms_sender_id" => "required",
        ]);
        $getapi = Api::first();
        $datarequest = $request->all();
        $status = $getapi->fill($datarequest)->save();
        if ($status) {
            request()
                ->session()
                ->flash(
                    "success",
                    "SMS Api Successfully updated. You may need to test your SMS API and then Turn On the SMS!!"
                );
        } else {
            request()
                ->session()
                ->flash("error", "The credentials were incorrect!!");
        }
        return redirect()->route("sms.index");
    }
    public function smsTest(Request $request)
    {
        $this->validate($request, [
            "phone" => "required",
        ]);
        $data = Api::first();
        if ($data->sms_status == "on") {
            $message = "This is a test message.";
            $message = urlencode($message);
            $phoneNumber = "88" . $request->phone; // The phone number to send the message to
            //dd($phoneNumber);
            $senderId = $data->sms_sender_id; // Your approved Sender ID
            $apiKey = $data->sms_api_key; // Your API key
            // Build the URL
            $url =
                "http://bulksmsbd.net/api/smsapi?api_key=" .
                $apiKey .
                "&type=text&number=" .
                $phoneNumber .
                "&senderid=" .
                $senderId .
                "&message=" .
                $message;
            // Initialize cURL
            $ch = curl_init();
            // Set cURL options
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            // Execute the request
            $response = curl_exec($ch);
            // Close the cURL session
            curl_close($ch);
            if ($response === false) {
                request()
                    ->session()
                    ->flash("error", curl_error($ch));
            } else {
                request()
                    ->session()
                    ->flash("success", "SMS Sent");
            }
        } else {
            request()
                ->session()
                ->flash("error", "SMS API is Off!");
        }
        return redirect()->route("sms.index");
    }
    public function smsstatus()
    {
        $data = Api::findOrfail(1);
        if ($data->sms_status == "on") {
            $data->sms_status = "off";
            request()
                ->session()
                ->flash("success", "SMS API is Off");
        } else {
            $data->sms_status = "on";
            request()
                ->session()
                ->flash("success", "SMS API is On");
        }
        $status = $data->save();
        if ($status) {
            return redirect()->route("sms.index");
        } else {
            request()
                ->session()
                ->flash("error", "Something is wrong!");
            return redirect()->route("sms.index");
        }
    }

    //SteadFast
    public function steadfast()
    {
        $info = SteadFast::first();
        return view("backend.api.steadfast", compact("info"));
    }
    public function steadFastUpdate(Request $request)
    {
        $this->validate($request, [
            "api_url" => "required",
            "steadfast_api_key" => "required",
            "steadfast_secret_key" => "required",
        ]);

        $api_url = $request->api_url;
        $steadfast_api_key = $request->steadfast_api_key;
        $steadfast_secret_key = $request->steadfast_secret_key;

        $info = SteadFast::first();
        if ($info) {
            $data = SteadFast::find($info->id);
            $data->api_url = $api_url;
            $data->steadfast_api_key = $steadfast_api_key;
            $data->steadfast_secret_key = $steadfast_secret_key;
            $data->save();
        } else {
            SteadFast::create($request->all());
        }

        request()
            ->session()
            ->flash("success", "Stead Fast API Successfully.");
        return back();
    }

    //Redx
    public function redx()
    {
        $info = Redx::first();
        return view("backend.api.redx", compact("info"));
    }
    public function redxUpdate(Request $request)
    {
        $this->validate($request, [
            "redx_api_base_url" => "required",
            "redx_api_access_token" => "required",
        ]);
        $redx_api_base_url = $request->redx_api_base_url;
        $redx_api_access_token = $request->redx_api_access_token;
        $info = Redx::first();
        if ($info) {
            $data = Redx::find($info->id);
            $data->redx_api_base_url = $redx_api_base_url;
            $data->redx_api_access_token = $redx_api_access_token;
            $data->save();
        } else {
            Redx::create($request->all());
        }
        request()
            ->session()
            ->flash("success", "Redx API Update Successfully.");
        return back();
    }

    //Pathao
    public function pathao()
    {
        $info = Pathao::first();
        return view("backend.api.pathao", compact("info"));
    }
    public function pathaoUpdate(Request $request)
    {
        $this->validate($request, [
            "pathao_api_base_url" => "required",
            "pathao_api_access_token" => "required",
            "pathao_store_id" => "required",
        ]);
        $pathao_api_base_url = $request->pathao_api_base_url;
        $pathao_api_access_token = $request->pathao_api_access_token;
        $pathao_store_id = $request->pathao_store_id;
        $info = Pathao::first();
        if ($info) {
            $data = Pathao::find($info->id);
            $data->pathao_api_base_url = $pathao_api_base_url;
            $data->pathao_api_access_token = $pathao_api_access_token;
            $data->pathao_store_id = $pathao_store_id;
            $data->save();
        } else {
            Pathao::create($request->all());
        }
        request()
            ->session()
            ->flash("success", "Pathao API Update Successfully.");
        return back();
    }

    public function getBalance()
    {
        // Fetching API key and secret key from database
        $info = SteadFast::first();

        // Making HTTP request to get the balance
        $response = Http::withHeaders([
            'Api-Key' => $info->steadfast_api_key,
            'Secret-Key' => $info->steadfast_secret_key,
        ])->get($info->api_url . 'get_balance');

        // Handling response
        if ($response->successful()) {
            // Extracting balance from the response JSON
            $currentBalance = $response->json()['current_balance'];

            // Returning JSON response with the balance
            return response()->json(['current_balance' => $currentBalance]);
        } else {
            // If request fails, return error response
            return response()->json([
                'error' => 'Failed to fetch balance.',
            ], $response->status());
        }
    }
}
