<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\StatusControl;

use Illuminate\Support\Str;

class StatusController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = StatusControl::get();
        return view('backend.status.index')->with('products', $products);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.status.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request, [
            'name' => 'string|required',
        ]);

        $data = $request->all();
        $status = StatusControl::create($data);
        if ($status) {

            request()->session()->flash('success', 'Status Successfully added');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('status.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = StatusControl::findOrFail($id);
        return view('backend.status.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Category = StatusControl::findOrFail($id);
        $this->validate($request, [
            'name' => 'string|required',
        ]);
        $data = $request->all();
        $status = $Category->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Status Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('status.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = StatusControl::findOrFail($id);

        $status = $category->delete();

        if ($status) {
            request()->session()->flash('success', 'Status successfully deleted');
        } else {
            request()->session()->flash('error', 'Error while deleting Status');
        }
        return redirect()->route('status.index');
    }
}
