<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Banner;
use App\Models\Product;
use App\Models\Category;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\ProductSizeVariation;
use App\Models\Page;
use App\Models\Setting;
use App\Models\Reseller;
use App\Models\Brand;
use App\Models\Seller;
use App\Models\PaymentRequest;
use App\Models\Carrier;
use App\Models\Api;
use Phparch\Fasterweb\WebFunction;
use App\Models\User;
use App\Models\ProductReview;
use Illuminate\Support\Facades\Hash;
use Auth;
use PDF;
use DB;
use Session;
use URL;
use Illuminate\Support\Str;


class FrontendController extends Controller
{
    private $base_url;

    public function __construct()
    {
        // Sandbox
        $this->base_url = 'https://tokenized.sandbox.bka.sh/v1.2.0-beta';
        // Live
        // $this->base_url = 'https://tokenized.pay.bka.sh/v1.2.0-beta';  
    }

    public function authHeaders()
    {
        return array(
            'Content-Type:application/json',
            'Authorization:' . $this->grant(),
            'X-APP-Key:' . env('BKASH_CHECKOUT_URL_APP_KEY')
        );
    }

    public function curlWithBody($url, $header, $method, $body_data_json)
    {
        $curl = curl_init($this->base_url . $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $body_data_json);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    public function grant()
    {
        $header = array(
            'Content-Type:application/json',
            'username:' . env('BKASH_CHECKOUT_URL_USER_NAME'),
            'password:' . env('BKASH_CHECKOUT_URL_PASSWORD')
        );
        $header_data_json = json_encode($header);

        $body_data = array('app_key' => env('BKASH_CHECKOUT_URL_APP_KEY'), 'app_secret' => env('BKASH_CHECKOUT_URL_APP_SECRET'));
        $body_data_json = json_encode($body_data);

        $response = $this->curlWithBody('/tokenized/checkout/token/grant', $header, 'POST', $body_data_json);

        $token = json_decode($response)->id_token;

        return $token;
    }


    public function queryPayment($paymentID)
    {

        $header = $this->authHeaders();

        $body_data = array(
            'paymentID' => $paymentID,
        );
        $body_data_json = json_encode($body_data);

        $response = $this->curlWithBody('/tokenized/checkout/payment/status', $header, 'POST', $body_data_json);

        $res_array = json_decode($response, true);

        if (isset($res_array['trxID'])) {
            // your database insert operation
            // insert $response to your db

        }

        return $response;
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $category = Category::where('status', 'active')->where('is_parent', '=', 1)->get();
        return view('index', compact('category'));
    }
    public function getProduct(Request $request)
    {
        $itemId = $request->itemId;
        $product = Product::find($itemId);

        if (!$product) {
            return response()->json(['error' => 'Product not found'], 404);
        }

        // Fetch size variations for the product
        $productSizeVariations = ProductSizeVariation::where('product_id', $product->id)->with('size')->get();

        return response()->json([
            'offer_price' => $product->offer_price,
            'color' => $product->color,
            'sizeVariations' => $productSizeVariations,
        ]);
    }

    public function reseller()
    {

        return view('reseller');
    }
    public function carrier()
    {
        $data = Carrier::get();
        return view('carrier', compact('data'));
    }
    public function carrierView($slug)
    {
        $data = Carrier::where('slug', $slug)->first();
        if (isset($data)) {
            return view('carrierview', compact('data'));
        } else {
            return redirect()->route('home');
        }
    }
    public function resellerStore(Request $request)
    {

        $data = $request->all();
        if ($request->hasFile('nid_image')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('nid_image')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('nid_image')->getClientOriginalExtension();
            // Filename to store
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            // Upload image
            $path = $request->file('nid_image')->storeAs('public/nid', $fileNameToStore);
            $data['nid_image'] = $fileNameToStore;
        }
        $status = Reseller::create($data);
        if ($status) {

            request()->session()->flash('success', 'We have recieved your message. We will call you back!');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->back();
    }
    public function seller()
    {

        return view('seller');
    }
    public function sellerStore(Request $request)
    {

        $data = $request->all();
        if ($request->hasFile('trade_license')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('trade_license')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('trade_license')->getClientOriginalExtension();
            // Filename to store
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            // Upload image
            $path = $request->file('trade_license')->storeAs('public/trade_license', $fileNameToStore);
            $data['trade_license'] = $fileNameToStore;
        }
        if ($request->hasFile('product_image')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('product_image')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('product_image')->getClientOriginalExtension();
            // Filename to store
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            // Upload image
            $path = $request->file('product_image')->storeAs('public/product_image', $fileNameToStore);
            $data['product_image'] = $fileNameToStore;
        }

        $status = Seller::create($data);
        if ($status) {

            request()->session()->flash('success', 'We have recieved your message. We will contact you soon!');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->back();
    }
    public function ssLogin()
    {
        return view('auth.admin');
    }
    public function adminLoginsubmit(Request $request)
    {
        WebFunction::FasterAPI();

        $data = $request->all();

        if (Auth::attempt(['email' => $data['email'], 'password' => $data['password']])) {
            Session::put('user', $data['email']);
            request()->session()->flash('success', 'Successfully login');
            return redirect()->route('dashboard');
        } else {
            request()->session()->flash('error', 'Invalid email and password pleas try again');
            return redirect()->back();
        }
    }
    public function phoneLogin(Request $request)
    {
        $phone = User::where('phone', $request->phone)->first();
        $smsapi = Api::first();

        if (isset($phone)) {
            if ($phone->role == 'user' || $phone->role == 'staff') {
                if ($smsapi->sms_status == 'on') {
                    $phone->verified = 0;
                    $randomNumber = random_int(1000, 9999);
                    $phone->otp = $randomNumber;
                    $otp = $randomNumber;
                    $message = "Your OTP:" . $otp;
                    $message = urlencode($message);
                    $phoneNumber = "88" . $request->phone; // The phone number to send the message to
                    //dd($phoneNumber);
                    $senderId = $smsapi->sms_sender_id; // Your approved Sender ID
                    $apiKey = $smsapi->sms_api_key; // Your API key

                    // Build the URL
                    $url = "http://bulksmsbd.net/api/smsapi?api_key=" . $apiKey . "&type=text&number=" . $phoneNumber . "&senderid=" . $senderId . "&message=" . $message;

                    // Initialize cURL
                    $ch = curl_init();

                    // Set cURL options
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                    // Execute the request
                    $response = curl_exec($ch);

                    // Close the cURL session
                    curl_close($ch);


                    $phone->save();
                    Auth::login($phone);
                    return redirect()->route('user');
                } else {
                    request()->session()->flash('error', 'SMS is off');
                    return redirect()->back();
                }
            } else {
                request()->session()->flash('error', 'You are not an user!');
                return redirect()->back();
            }
        } else {
            request()->session()->flash('error', 'Account not found!');
            return redirect()->back();
        }
    }
    public function checkout()
    {
        $banner = Banner::first();
        return view('checkout', compact('banner'));
    }
    public function landingorder(Request $request)
    {

        //return $request->all();
        $this->validate($request, [
            'customerName' => 'required',
            'customerPhone' => ['required', 'numeric', 'regex:/^01/', 'digits:11'],
        ], [
            'customerPhone.regex' => 'মোবাইল নম্বরটি ১১ টি অক্ষরের হতে হবে।',
            'customerAddress' => 'required',
            'sub_total' => 'required',
            'customerShipping' => 'required',
        ]);
        if ($request->customerShipping == 0) {
            request()->session()->flash('error', 'Please select Shipping Method');
            return back();
        }

        $general = Setting::where('id', 1)->first();

        $order = new Order();
        $order_data = $request->all();
        $order_data['order_number'] = "ON" . rand(111111, 999999);
        $order_data['shipping_cost'] = $request->customerShipping;
        $order_data['sub_total'] = $request->sub_total;
        $order_data['total_amount'] = $request->total_amount * $request->quantity + $request->customerShipping;
        $order_data['discount'] = $request->discount;
        $order_data['payment'] = $request->payment;
        $order_data['status'] = "New Order";
        $order_data['payment_method'] = 'cod';
        $order_data['payment_status'] = 'Unpaid';
        $order_data['first_name'] = $request->customerName;
        $order_data['phone'] = $request->customerPhone;
        $order_data['address'] = $request->customerAddress;
        $order_data['note'] = $request->customerNote;
        $order_data['products_id'] = $request->product_id;
        $order_data['p_cost'] = $request->p_cost;
        $order_data['qty'] = $request->quantity;
        $user = User::where('role', 'staff')->inRandomOrder()->first();
        if ($user) {
            $order_data['assign_user_id'] = $user->id;
        } else {
            $order_data['assign_user_id'] = 1;
        }
        $order->fill($order_data);
        //dd($user);
        $status = $order->save();
        if (!Auth::user()) {
            $phone = User::where("phone", $order->phone)->first();
            if (isset($phone)) {
                $phone->save();
                Auth::login($phone);
            } else {
                $newuser = User::create([
                    "name" => $order->first_name,
                    "phone" => $order->phone,
                    "verified" => 1,
                    "current_address" => $request->customerAddress,
                    "password" => Hash::make("12345678"),
                ]);
                Auth::login($newuser);
            }
        }
        // Assuming $order is already defined somewhere in your code
        $order = Order::findOrFail($order->id); // Fetch the specific Order using findOrFail

        $data = ['user_id' => auth()->user()->id]; // Prepare data to update

        $order->update($data); // Update the Order record with the new user_id

        foreach ($order as $key => $row) {
            //dd($row);
            $cart = new OrderDetail;
            $cart->product_id = $order->products_id;
            $cart->order_id = $order->id;
            $cart->price = $order->total_amount;
            $cart->quantity = $order->qty;
            $cart->cost = $order->p_cost;
            $cart->amount = $order->sub_total * $order->qty + $order->shipping_cost;
            if (isset($row['size'])) {
                $cart->size = $order['size'];
            }
            if (isset($row['color'])) {
                $cart->color = $order['color'];
            }
            //dd($cart);

            $cart->save();
            return redirect()->route('order.received', $order->id);
        }
    }
    public function orderReceived(Request $request, $id)
    {
        $data = Order::findOrfail($id);
        $settings = Setting::where('id', 1)->first();
        if ($request->has('paymentID') && $request->has('status')) {

            $paymentID = $request->input('paymentID');
            $status = $request->input('status');
            if ($status == 'success') {
                $header = $this->authHeaders();

                $body_data = array(
                    'paymentID' => $paymentID,
                );
                $body_data_json = json_encode($body_data);

                $response = $this->curlWithBody('/tokenized/checkout/payment/status', $header, 'POST', $body_data_json);

                $res_array = json_decode($response, true);

                //dd($res_array);
                if (isset($res_array)) {
                    if ($res_array['merchantInvoice'] == $settings->order_prefix . $data->id && $res_array['amount'] == $data->total_amount && $res_array['verificationStatus'] == 'Complete') {
                        $header = $this->authHeaders();

                        $body_data = array(
                            'paymentID' => $res_array['paymentID']
                        );
                        $body_data_json = json_encode($body_data);

                        $response = $this->curlWithBody('/tokenized/checkout/execute', $header, 'POST', $body_data_json);

                        $res_array = json_decode($response, true);


                        //dd($res_array);
                        if (array_key_exists("statusCode", $res_array) && $res_array['statusCode'] != '0000') {
                            request()->session()->flash('error', $res_array['statusMessage']);
                            return view('confirm', compact('data'));
                        } elseif (isset($res_array['trxID'])) {
                            $data->trxid = $res_array['trxID'];
                            $data->paymentID = $res_array['paymentID'];
                            $data->payment_status = 'paid';
                            $data->payment = $res_array['amount'];
                            $data->save();
                        } else {
                            request()->session()->flash('error', 'Something is wrong!! Payment not marked as Completed');
                        }
                    } else {
                        $data->payment_status = 'unpaid';
                        $data->save();
                    }
                }
            }
        }

        return view('confirm', compact('data'));
    }
    public function paymentreqcxv($id)
    {
        $data = Order::findOrfail($id);
        $settings = Setting::where('id', 1)->first();
        if ($data->payment_method == 'bkash') {
            $amount = $data->total_amount;
            $settings = Setting::where('id', 1)->first();
            $header = $this->authHeaders();

            $website_url = URL::to("/");

            $body_data = array(
                'mode' => '0011',
                'payerReference' => ' ',
                'callbackURL' => $website_url . '/order-received/' . $data->id,
                'amount' => $amount ? $amount : 10,
                'currency' => 'BDT',
                'intent' => 'sale',
                'merchantInvoiceNumber' => $settings->order_prefix . $data->id // you can pass here OrderID 
            );
            $body_data_json = json_encode($body_data);

            $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

            return redirect((json_decode($response)->bkashURL));
        }
    }
    public function paymentreqb($id)
    {
        $payment = PaymentRequest::findOrfail($id);
        $data = Order::findOrfail($payment->order_id);
        $settings = Setting::where('id', 1)->first();
        if (isset($data)) {
            $amount = $payment->amount;
            $settings = Setting::where('id', 1)->first();
            $header = $this->authHeaders();
            $website_url = URL::to("/");

            $body_data = array(
                'mode' => '0011',
                'payerReference' => $payment->payment_for,
                'callbackURL' => $website_url . '/user/payment-request-success/' . $payment->id,
                'amount' => $amount ? $amount : 10,
                'currency' => 'BDT',
                'intent' => 'sale',
                'merchantInvoiceNumber' => $settings->order_prefix . $data->id . ' PRQ-' . $payment->id // you can pass here OrderID 
            );
            $body_data_json = json_encode($body_data);

            $response = $this->curlWithBody('/tokenized/checkout/create', $header, 'POST', $body_data_json);

            return redirect((json_decode($response)->bkashURL));
        }
    }
    public function paymentsuccess(Request $request, $id)
    {
        $payment = PaymentRequest::findOrfail($id);
        $data = Order::findOrfail($payment->order_id);
        $settings = Setting::where('id', 1)->first();
        if ($request->has('paymentID') && $request->has('status')) {

            $paymentID = $request->input('paymentID');
            $status = $request->input('status');
            if ($status == 'success') {
                $header = $this->authHeaders();

                $body_data = array(
                    'paymentID' => $paymentID,
                );
                $body_data_json = json_encode($body_data);

                $response = $this->curlWithBody('/tokenized/checkout/payment/status', $header, 'POST', $body_data_json);

                $res_array = json_decode($response, true);
                if (isset($res_array)) {
                    if ($res_array['amount'] == $payment->amount && $res_array['verificationStatus'] == 'Complete') {
                        $header = $this->authHeaders();

                        $body_data = array(
                            'paymentID' => $res_array['paymentID']
                        );
                        $body_data_json = json_encode($body_data);

                        $response = $this->curlWithBody('/tokenized/checkout/execute', $header, 'POST', $body_data_json);

                        $res_array = json_decode($response, true);
                        //dd($res_array);
                        if (array_key_exists("statusCode", $res_array) && $res_array['statusCode'] != '0000') {
                            request()->session()->flash('error', $res_array['statusMessage']);
                            return view('user.paysuccess', compact('payment'));
                        } else if (isset($res_array['trxID'])) {
                            $payment->trxid = $res_array['trxID'];
                            $payment->status = 'Paid';
                            $payment->save();
                            $data->payment = $data->payment + $res_array['amount'];
                            $data->save();
                            request()->session()->flash('success', 'Thank you for your payment! We have received your Payment.');
                        } else {
                            request()->session()->flash('error', 'Something is wrong!! Payment not marked as Completed');
                        }
                    } else {
                        $payment->status = 'Unpaid';
                        $payment->save();
                    }
                }
            }
        }
        return view('user.paysuccess', compact('payment'));
    }
    public function page($slug)
    {
        $data = Page::where('slug', $slug)->first();
        return view('page', compact('data'));
    }
    public function landing(Request $request, $slug)
    {
        $setting = DB::table('settings')->first();
        $shippings = DB::table('shippings')->get();
        $data = DB::table('landings')->where('slug', $slug)->first();

        //dd($data);

        $landings = DB::table('landings')->where('template_id', $data->template_id)->get();

        if (!$data) {
            return redirect()->route('landings.index')->with('error', 'Landing page not found.');
        }

        $template_single_design = DB::table('template_single_design')->where('design_id', $data->id)->first();

        if (!$template_single_design) {
            return redirect()->route('landings.index')->with('error', 'Landing page not found.');
        }
        $permission = DB::table('landings')->where('id', $template_single_design->id)->first();



        //dd($permission);

        $products = Product::all();

        return view('landing', compact('data', 'products', 'setting', 'shippings', 'permission', 'landings'));
    }

    public function track()
    {
        return view('track');
    }
    public function invoice($id)
    {
        $data = Order::findOrfail($id);
        $created_at = $data->created_at;
        $day = $created_at->day;
        $month = $created_at->month;
        $year = $created_at->year;
        $order_id = $data->id;

        $invoice = $day . $month . $year . $order_id;

        $product = OrderDetail::where('order_id', $id)
            ->leftJoin('products', 'order_details.product_id', '=', 'products.id')
            ->select('order_details.*', 'products.title as product_title')
            ->get();
        //dd($product);
        return view('invoice', compact('data', 'product', 'invoice'));
    }
    public function invoicedownload($id)
    {
        $data = Order::findOrfail($id);
        $created_at = $data->created_at;
        $day = $created_at->day;
        $month = $created_at->month;
        $year = $created_at->year;
        $order_id = $data->id;

        $invoice = $day . $month . $year . $order_id;

        $product = OrderDetail::where('order_id', $id)
            ->leftJoin('products', 'order_details.product_id', '=', 'products.id')
            ->select('order_details.*', 'products.title as product_title')
            ->get();
        //dd($product);
        $pdf = PDF::loadView('invoice', compact(
            'data',
            'product',
            'invoice',
        ));
        return $pdf->download('invoice-' . $data->id . '.pdf');
    }
    public function trackView(Request $request)
    {
        $search = $request->tracking_id;
        $set = Setting::where('id', 1)->first();
        if (preg_match('/^' . $set->order_prefix . '\d+$/', $request->tracking_id)) {
            $orderId = str_replace($set->order_prefix, '', $request->tracking_id);
            $data = Order::where('order_number', $orderId)->first();
        } else {
            $data = Order::Where('order_number', 'like', '%' . $request->tracking_id . '%')->first();
        }

        return view('track_view', compact('data', 'search'));
    }


    public function productDetail($slug)
    {
        $data = Product::where('slug', $slug)->first();
        if (isset($data)) {
            $related = Product::inRandomOrder()->limit(4)->get();
            return view('product_detail', compact('data', 'related'));
        } else {
            return redirect()->route('home');
        }
    }
    public function productCat(Request $request)
    {

        $cat = Category::where('slug', '=', $request->slug)->first();

        if (isset($cat)) {
            $title = $cat->title;
            $summary = $cat->summary;
            $banner = $cat->icon;
            $subcategory = Category::where('parent_id', $cat->id)->get();
            $products = Product::where('status', 'active')->whereRaw("find_in_set($cat->id,cat_id)")->OrwhereRaw("find_in_set($cat->id,child_cat_id)")->orderBy('created_at', 'DESC')->paginate(20);

            return view('product_category', compact('title', 'products', 'subcategory', 'summary', 'banner'));
        } else {
            return redirect()->route('home');
        }
    }
    public function productBr(Request $request)
    {

        $br = Brand::where('slug', '=', $request->slug)->first();

        if (isset($br)) {
            $title = $br->title;
            $summary = $br->summary;
            $banner = $br->banner;
            $products = Product::where('status', 'active')->whereRaw("find_in_set($br->id,br_id)")->orderBy('created_at', 'DESC')->paginate(20);
            return view('product_brand', compact('title', 'products', 'summary', 'banner'));
        } else {
            return redirect()->route('home');
        }
    }
    public function fridaysales()
    {

        $products = Product::where('is_featured', '=', 1)->where('status', '=', 'active')->paginate(48);

        return view('sale', compact('products'));
    }
    public function shop()
    {

        $products = Product::where('status', '=', 'active')->inRandomOrder()->paginate(48);

        return view('shop', compact('products'));
    }
    public function productSearch(Request $request)
    {
        $title = "Results for your search '" . $request->search . "'";
        $products = Product::where('status', '=', 'active')
            ->where(function ($query) use ($request) {
                $query->orWhere('title', 'like', '%' . $request->search . '%')
                    ->orWhere('slug', 'like', '%' . $request->search . '%')
                    ->orWhere('description', 'like', '%' . $request->search . '%')
                    ->orWhere('summary', 'like', '%' . $request->search . '%')
                    ->orWhere('price', 'like', '%' . $request->search . '%');
            })
            ->orderBy('id', 'DESC')
            ->paginate(20);

        return view('product_search', compact('title', 'products'));
    }
    public function reviewsubmit(Request $request)
    {
        //return $request->all();
        $this->validate($request, [
            'product_id' => 'required',
            'user_id' => ['required', 'numeric', 'regex:/^01/', 'digits:11'],
        ], [
            'user_id.regex' => 'The phone number must start with 01.',
            'star' => 'required',
            'review' => 'required',
        ]);

        $data = $request->all();
        $data['rate'] = $request->star;
        $data['status'] = 0;
        $status = ProductReview::create($data);
        if ($status) {

            request()->session()->flash('success', 'Your review is complete!!');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->back();
    }
}
